<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMetaData ArrayType
 * @subpackage Arrays
 */
class ArrayOfMetaData extends AbstractStructArrayBase
{
    /**
     * The MetaData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MetaData[]
     */
    public $MetaData;
    /**
     * Constructor method for ArrayOfMetaData
     * @uses ArrayOfMetaData::setMetaData()
     * @param \StructType\MetaData[] $metaData
     */
    public function __construct(array $metaData = array())
    {
        $this
            ->setMetaData($metaData);
    }
    /**
     * Get MetaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MetaData[]|null
     */
    public function getMetaData()
    {
        return isset($this->MetaData) ? $this->MetaData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMetaData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMetaData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMetaDataForArrayConstraintsFromSetMetaData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMetaDataMetaDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfMetaDataMetaDataItem instanceof \StructType\MetaData) {
                $invalidValues[] = is_object($arrayOfMetaDataMetaDataItem) ? get_class($arrayOfMetaDataMetaDataItem) : sprintf('%s(%s)', gettype($arrayOfMetaDataMetaDataItem), var_export($arrayOfMetaDataMetaDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MetaData property can only contain items of type \StructType\MetaData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MetaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MetaData[] $metaData
     * @return \ArrayType\ArrayOfMetaData
     */
    public function setMetaData(array $metaData = array())
    {
        // validation for constraint: array
        if ('' !== ($metaDataArrayErrorMessage = self::validateMetaDataForArrayConstraintsFromSetMetaData($metaData))) {
            throw new \InvalidArgumentException($metaDataArrayErrorMessage, __LINE__);
        }
        if (is_null($metaData) || (is_array($metaData) && empty($metaData))) {
            unset($this->MetaData);
        } else {
            $this->MetaData = $metaData;
        }
        return $this;
    }
    /**
     * Add item to MetaData value
     * @throws \InvalidArgumentException
     * @param \StructType\MetaData $item
     * @return \ArrayType\ArrayOfMetaData
     */
    public function addToMetaData(\StructType\MetaData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MetaData) {
            throw new \InvalidArgumentException(sprintf('The MetaData property can only contain items of type \StructType\MetaData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MetaData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MetaData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MetaData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MetaData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MetaData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MetaData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MetaData
     */
    public function getAttributeName()
    {
        return 'MetaData';
    }
}
