<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapPosition ArrayType
 * @subpackage Arrays
 */
class ArrayOfMapPosition extends AbstractStructArrayBase
{
    /**
     * The MapPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MapPosition[]
     */
    public $MapPosition;
    /**
     * Constructor method for ArrayOfMapPosition
     * @uses ArrayOfMapPosition::setMapPosition()
     * @param \StructType\MapPosition[] $mapPosition
     */
    public function __construct(array $mapPosition = array())
    {
        $this
            ->setMapPosition($mapPosition);
    }
    /**
     * Get MapPosition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MapPosition[]|null
     */
    public function getMapPosition()
    {
        return isset($this->MapPosition) ? $this->MapPosition : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMapPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMapPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMapPositionForArrayConstraintsFromSetMapPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMapPositionMapPositionItem) {
            // validation for constraint: itemType
            if (!$arrayOfMapPositionMapPositionItem instanceof \StructType\MapPosition) {
                $invalidValues[] = is_object($arrayOfMapPositionMapPositionItem) ? get_class($arrayOfMapPositionMapPositionItem) : sprintf('%s(%s)', gettype($arrayOfMapPositionMapPositionItem), var_export($arrayOfMapPositionMapPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MapPosition property can only contain items of type \StructType\MapPosition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MapPosition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MapPosition[] $mapPosition
     * @return \ArrayType\ArrayOfMapPosition
     */
    public function setMapPosition(array $mapPosition = array())
    {
        // validation for constraint: array
        if ('' !== ($mapPositionArrayErrorMessage = self::validateMapPositionForArrayConstraintsFromSetMapPosition($mapPosition))) {
            throw new \InvalidArgumentException($mapPositionArrayErrorMessage, __LINE__);
        }
        if (is_null($mapPosition) || (is_array($mapPosition) && empty($mapPosition))) {
            unset($this->MapPosition);
        } else {
            $this->MapPosition = $mapPosition;
        }
        return $this;
    }
    /**
     * Add item to MapPosition value
     * @throws \InvalidArgumentException
     * @param \StructType\MapPosition $item
     * @return \ArrayType\ArrayOfMapPosition
     */
    public function addToMapPosition(\StructType\MapPosition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MapPosition) {
            throw new \InvalidArgumentException(sprintf('The MapPosition property can only contain items of type \StructType\MapPosition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MapPosition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MapPosition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MapPosition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MapPosition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MapPosition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MapPosition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapPosition
     */
    public function getAttributeName()
    {
        return 'MapPosition';
    }
}
