<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobResult extends AbstractStructArrayBase
{
    /**
     * The JobResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobResult[]
     */
    public $JobResult;
    /**
     * Constructor method for ArrayOfJobResult
     * @uses ArrayOfJobResult::setJobResult()
     * @param \StructType\JobResult[] $jobResult
     */
    public function __construct(array $jobResult = array())
    {
        $this
            ->setJobResult($jobResult);
    }
    /**
     * Get JobResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobResult[]|null
     */
    public function getJobResult()
    {
        return isset($this->JobResult) ? $this->JobResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJobResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJobResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJobResultForArrayConstraintsFromSetJobResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJobResultJobResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobResultJobResultItem instanceof \StructType\JobResult) {
                $invalidValues[] = is_object($arrayOfJobResultJobResultItem) ? get_class($arrayOfJobResultJobResultItem) : sprintf('%s(%s)', gettype($arrayOfJobResultJobResultItem), var_export($arrayOfJobResultJobResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JobResult property can only contain items of type \StructType\JobResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JobResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobResult[] $jobResult
     * @return \ArrayType\ArrayOfJobResult
     */
    public function setJobResult(array $jobResult = array())
    {
        // validation for constraint: array
        if ('' !== ($jobResultArrayErrorMessage = self::validateJobResultForArrayConstraintsFromSetJobResult($jobResult))) {
            throw new \InvalidArgumentException($jobResultArrayErrorMessage, __LINE__);
        }
        if (is_null($jobResult) || (is_array($jobResult) && empty($jobResult))) {
            unset($this->JobResult);
        } else {
            $this->JobResult = $jobResult;
        }
        return $this;
    }
    /**
     * Add item to JobResult value
     * @throws \InvalidArgumentException
     * @param \StructType\JobResult $item
     * @return \ArrayType\ArrayOfJobResult
     */
    public function addToJobResult(\StructType\JobResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobResult) {
            throw new \InvalidArgumentException(sprintf('The JobResult property can only contain items of type \StructType\JobResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JobResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobResult
     */
    public function getAttributeName()
    {
        return 'JobResult';
    }
}
