<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFileTransfer ArrayType
 * @subpackage Arrays
 */
class ArrayOfFileTransfer extends AbstractStructArrayBase
{
    /**
     * The FileTransfer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FileTransfer[]
     */
    public $FileTransfer;
    /**
     * Constructor method for ArrayOfFileTransfer
     * @uses ArrayOfFileTransfer::setFileTransfer()
     * @param \StructType\FileTransfer[] $fileTransfer
     */
    public function __construct(array $fileTransfer = array())
    {
        $this
            ->setFileTransfer($fileTransfer);
    }
    /**
     * Get FileTransfer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FileTransfer[]|null
     */
    public function getFileTransfer()
    {
        return isset($this->FileTransfer) ? $this->FileTransfer : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFileTransfer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFileTransfer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFileTransferForArrayConstraintsFromSetFileTransfer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFileTransferFileTransferItem) {
            // validation for constraint: itemType
            if (!$arrayOfFileTransferFileTransferItem instanceof \StructType\FileTransfer) {
                $invalidValues[] = is_object($arrayOfFileTransferFileTransferItem) ? get_class($arrayOfFileTransferFileTransferItem) : sprintf('%s(%s)', gettype($arrayOfFileTransferFileTransferItem), var_export($arrayOfFileTransferFileTransferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FileTransfer property can only contain items of type \StructType\FileTransfer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FileTransfer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FileTransfer[] $fileTransfer
     * @return \ArrayType\ArrayOfFileTransfer
     */
    public function setFileTransfer(array $fileTransfer = array())
    {
        // validation for constraint: array
        if ('' !== ($fileTransferArrayErrorMessage = self::validateFileTransferForArrayConstraintsFromSetFileTransfer($fileTransfer))) {
            throw new \InvalidArgumentException($fileTransferArrayErrorMessage, __LINE__);
        }
        if (is_null($fileTransfer) || (is_array($fileTransfer) && empty($fileTransfer))) {
            unset($this->FileTransfer);
        } else {
            $this->FileTransfer = $fileTransfer;
        }
        return $this;
    }
    /**
     * Add item to FileTransfer value
     * @throws \InvalidArgumentException
     * @param \StructType\FileTransfer $item
     * @return \ArrayType\ArrayOfFileTransfer
     */
    public function addToFileTransfer(\StructType\FileTransfer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FileTransfer) {
            throw new \InvalidArgumentException(sprintf('The FileTransfer property can only contain items of type \StructType\FileTransfer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FileTransfer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FileTransfer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FileTransfer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FileTransfer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FileTransfer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FileTransfer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FileTransfer
     */
    public function getAttributeName()
    {
        return 'FileTransfer';
    }
}
