<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFileResultItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfFileResultItem extends AbstractStructArrayBase
{
    /**
     * The FileResultItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FileResultItem[]
     */
    public $FileResultItem;
    /**
     * Constructor method for ArrayOfFileResultItem
     * @uses ArrayOfFileResultItem::setFileResultItem()
     * @param \StructType\FileResultItem[] $fileResultItem
     */
    public function __construct(array $fileResultItem = array())
    {
        $this
            ->setFileResultItem($fileResultItem);
    }
    /**
     * Get FileResultItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FileResultItem[]|null
     */
    public function getFileResultItem()
    {
        return isset($this->FileResultItem) ? $this->FileResultItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFileResultItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFileResultItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFileResultItemForArrayConstraintsFromSetFileResultItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFileResultItemFileResultItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfFileResultItemFileResultItemItem instanceof \StructType\FileResultItem) {
                $invalidValues[] = is_object($arrayOfFileResultItemFileResultItemItem) ? get_class($arrayOfFileResultItemFileResultItemItem) : sprintf('%s(%s)', gettype($arrayOfFileResultItemFileResultItemItem), var_export($arrayOfFileResultItemFileResultItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FileResultItem property can only contain items of type \StructType\FileResultItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FileResultItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FileResultItem[] $fileResultItem
     * @return \ArrayType\ArrayOfFileResultItem
     */
    public function setFileResultItem(array $fileResultItem = array())
    {
        // validation for constraint: array
        if ('' !== ($fileResultItemArrayErrorMessage = self::validateFileResultItemForArrayConstraintsFromSetFileResultItem($fileResultItem))) {
            throw new \InvalidArgumentException($fileResultItemArrayErrorMessage, __LINE__);
        }
        if (is_null($fileResultItem) || (is_array($fileResultItem) && empty($fileResultItem))) {
            unset($this->FileResultItem);
        } else {
            $this->FileResultItem = $fileResultItem;
        }
        return $this;
    }
    /**
     * Add item to FileResultItem value
     * @throws \InvalidArgumentException
     * @param \StructType\FileResultItem $item
     * @return \ArrayType\ArrayOfFileResultItem
     */
    public function addToFileResultItem(\StructType\FileResultItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FileResultItem) {
            throw new \InvalidArgumentException(sprintf('The FileResultItem property can only contain items of type \StructType\FileResultItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FileResultItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FileResultItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FileResultItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FileResultItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FileResultItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FileResultItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FileResultItem
     */
    public function getAttributeName()
    {
        return 'FileResultItem';
    }
}
