<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDriverSubGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDriverSubGroupItem extends AbstractStructArrayBase
{
    /**
     * The DriverSubGroupItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DriverSubGroupItem[]
     */
    public $DriverSubGroupItem;
    /**
     * Constructor method for ArrayOfDriverSubGroupItem
     * @uses ArrayOfDriverSubGroupItem::setDriverSubGroupItem()
     * @param \StructType\DriverSubGroupItem[] $driverSubGroupItem
     */
    public function __construct(array $driverSubGroupItem = array())
    {
        $this
            ->setDriverSubGroupItem($driverSubGroupItem);
    }
    /**
     * Get DriverSubGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DriverSubGroupItem[]|null
     */
    public function getDriverSubGroupItem()
    {
        return isset($this->DriverSubGroupItem) ? $this->DriverSubGroupItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDriverSubGroupItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriverSubGroupItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverSubGroupItemForArrayConstraintsFromSetDriverSubGroupItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDriverSubGroupItemDriverSubGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDriverSubGroupItemDriverSubGroupItemItem instanceof \StructType\DriverSubGroupItem) {
                $invalidValues[] = is_object($arrayOfDriverSubGroupItemDriverSubGroupItemItem) ? get_class($arrayOfDriverSubGroupItemDriverSubGroupItemItem) : sprintf('%s(%s)', gettype($arrayOfDriverSubGroupItemDriverSubGroupItemItem), var_export($arrayOfDriverSubGroupItemDriverSubGroupItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DriverSubGroupItem property can only contain items of type \StructType\DriverSubGroupItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DriverSubGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DriverSubGroupItem[] $driverSubGroupItem
     * @return \ArrayType\ArrayOfDriverSubGroupItem
     */
    public function setDriverSubGroupItem(array $driverSubGroupItem = array())
    {
        // validation for constraint: array
        if ('' !== ($driverSubGroupItemArrayErrorMessage = self::validateDriverSubGroupItemForArrayConstraintsFromSetDriverSubGroupItem($driverSubGroupItem))) {
            throw new \InvalidArgumentException($driverSubGroupItemArrayErrorMessage, __LINE__);
        }
        if (is_null($driverSubGroupItem) || (is_array($driverSubGroupItem) && empty($driverSubGroupItem))) {
            unset($this->DriverSubGroupItem);
        } else {
            $this->DriverSubGroupItem = $driverSubGroupItem;
        }
        return $this;
    }
    /**
     * Add item to DriverSubGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DriverSubGroupItem $item
     * @return \ArrayType\ArrayOfDriverSubGroupItem
     */
    public function addToDriverSubGroupItem(\StructType\DriverSubGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DriverSubGroupItem) {
            throw new \InvalidArgumentException(sprintf('The DriverSubGroupItem property can only contain items of type \StructType\DriverSubGroupItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DriverSubGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DriverSubGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DriverSubGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DriverSubGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DriverSubGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DriverSubGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DriverSubGroupItem
     */
    public function getAttributeName()
    {
        return 'DriverSubGroupItem';
    }
}
