<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentsResult_V4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumentsResult_V4 extends AbstractStructArrayBase
{
    /**
     * The DocumentsResult_V4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentsResult_V4[]
     */
    public $DocumentsResult_V4;
    /**
     * Constructor method for ArrayOfDocumentsResult_V4
     * @uses ArrayOfDocumentsResult_V4::setDocumentsResult_V4()
     * @param \StructType\DocumentsResult_V4[] $documentsResult_V4
     */
    public function __construct(array $documentsResult_V4 = array())
    {
        $this
            ->setDocumentsResult_V4($documentsResult_V4);
    }
    /**
     * Get DocumentsResult_V4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentsResult_V4[]|null
     */
    public function getDocumentsResult_V4()
    {
        return isset($this->DocumentsResult_V4) ? $this->DocumentsResult_V4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentsResult_V4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentsResult_V4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsResult_V4ForArrayConstraintsFromSetDocumentsResult_V4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentsResult_V4DocumentsResult_V4Item) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentsResult_V4DocumentsResult_V4Item instanceof \StructType\DocumentsResult_V4) {
                $invalidValues[] = is_object($arrayOfDocumentsResult_V4DocumentsResult_V4Item) ? get_class($arrayOfDocumentsResult_V4DocumentsResult_V4Item) : sprintf('%s(%s)', gettype($arrayOfDocumentsResult_V4DocumentsResult_V4Item), var_export($arrayOfDocumentsResult_V4DocumentsResult_V4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentsResult_V4 property can only contain items of type \StructType\DocumentsResult_V4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentsResult_V4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentsResult_V4[] $documentsResult_V4
     * @return \ArrayType\ArrayOfDocumentsResult_V4
     */
    public function setDocumentsResult_V4(array $documentsResult_V4 = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsResult_V4ArrayErrorMessage = self::validateDocumentsResult_V4ForArrayConstraintsFromSetDocumentsResult_V4($documentsResult_V4))) {
            throw new \InvalidArgumentException($documentsResult_V4ArrayErrorMessage, __LINE__);
        }
        if (is_null($documentsResult_V4) || (is_array($documentsResult_V4) && empty($documentsResult_V4))) {
            unset($this->DocumentsResult_V4);
        } else {
            $this->DocumentsResult_V4 = $documentsResult_V4;
        }
        return $this;
    }
    /**
     * Add item to DocumentsResult_V4 value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentsResult_V4 $item
     * @return \ArrayType\ArrayOfDocumentsResult_V4
     */
    public function addToDocumentsResult_V4(\StructType\DocumentsResult_V4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentsResult_V4) {
            throw new \InvalidArgumentException(sprintf('The DocumentsResult_V4 property can only contain items of type \StructType\DocumentsResult_V4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentsResult_V4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DocumentsResult_V4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DocumentsResult_V4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DocumentsResult_V4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DocumentsResult_V4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DocumentsResult_V4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentsResult_V4
     */
    public function getAttributeName()
    {
        return 'DocumentsResult_V4';
    }
}
