<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCharacteristicItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfCharacteristicItem extends AbstractStructArrayBase
{
    /**
     * The CharacteristicItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CharacteristicItem[]
     */
    public $CharacteristicItem;
    /**
     * Constructor method for ArrayOfCharacteristicItem
     * @uses ArrayOfCharacteristicItem::setCharacteristicItem()
     * @param \StructType\CharacteristicItem[] $characteristicItem
     */
    public function __construct(array $characteristicItem = array())
    {
        $this
            ->setCharacteristicItem($characteristicItem);
    }
    /**
     * Get CharacteristicItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CharacteristicItem[]|null
     */
    public function getCharacteristicItem()
    {
        return isset($this->CharacteristicItem) ? $this->CharacteristicItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCharacteristicItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharacteristicItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCharacteristicItemForArrayConstraintsFromSetCharacteristicItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCharacteristicItemCharacteristicItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfCharacteristicItemCharacteristicItemItem instanceof \StructType\CharacteristicItem) {
                $invalidValues[] = is_object($arrayOfCharacteristicItemCharacteristicItemItem) ? get_class($arrayOfCharacteristicItemCharacteristicItemItem) : sprintf('%s(%s)', gettype($arrayOfCharacteristicItemCharacteristicItemItem), var_export($arrayOfCharacteristicItemCharacteristicItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CharacteristicItem property can only contain items of type \StructType\CharacteristicItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CharacteristicItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CharacteristicItem[] $characteristicItem
     * @return \ArrayType\ArrayOfCharacteristicItem
     */
    public function setCharacteristicItem(array $characteristicItem = array())
    {
        // validation for constraint: array
        if ('' !== ($characteristicItemArrayErrorMessage = self::validateCharacteristicItemForArrayConstraintsFromSetCharacteristicItem($characteristicItem))) {
            throw new \InvalidArgumentException($characteristicItemArrayErrorMessage, __LINE__);
        }
        if (is_null($characteristicItem) || (is_array($characteristicItem) && empty($characteristicItem))) {
            unset($this->CharacteristicItem);
        } else {
            $this->CharacteristicItem = $characteristicItem;
        }
        return $this;
    }
    /**
     * Add item to CharacteristicItem value
     * @throws \InvalidArgumentException
     * @param \StructType\CharacteristicItem $item
     * @return \ArrayType\ArrayOfCharacteristicItem
     */
    public function addToCharacteristicItem(\StructType\CharacteristicItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CharacteristicItem) {
            throw new \InvalidArgumentException(sprintf('The CharacteristicItem property can only contain items of type \StructType\CharacteristicItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CharacteristicItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CharacteristicItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CharacteristicItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CharacteristicItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CharacteristicItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CharacteristicItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CharacteristicItem
     */
    public function getAttributeName()
    {
        return 'CharacteristicItem';
    }
}
