<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCalibrationItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfCalibrationItem extends AbstractStructArrayBase
{
    /**
     * The CalibrationItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CalibrationItem[]
     */
    public $CalibrationItem;
    /**
     * Constructor method for ArrayOfCalibrationItem
     * @uses ArrayOfCalibrationItem::setCalibrationItem()
     * @param \StructType\CalibrationItem[] $calibrationItem
     */
    public function __construct(array $calibrationItem = array())
    {
        $this
            ->setCalibrationItem($calibrationItem);
    }
    /**
     * Get CalibrationItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CalibrationItem[]|null
     */
    public function getCalibrationItem()
    {
        return isset($this->CalibrationItem) ? $this->CalibrationItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCalibrationItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCalibrationItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCalibrationItemForArrayConstraintsFromSetCalibrationItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCalibrationItemCalibrationItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfCalibrationItemCalibrationItemItem instanceof \StructType\CalibrationItem) {
                $invalidValues[] = is_object($arrayOfCalibrationItemCalibrationItemItem) ? get_class($arrayOfCalibrationItemCalibrationItemItem) : sprintf('%s(%s)', gettype($arrayOfCalibrationItemCalibrationItemItem), var_export($arrayOfCalibrationItemCalibrationItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CalibrationItem property can only contain items of type \StructType\CalibrationItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CalibrationItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CalibrationItem[] $calibrationItem
     * @return \ArrayType\ArrayOfCalibrationItem
     */
    public function setCalibrationItem(array $calibrationItem = array())
    {
        // validation for constraint: array
        if ('' !== ($calibrationItemArrayErrorMessage = self::validateCalibrationItemForArrayConstraintsFromSetCalibrationItem($calibrationItem))) {
            throw new \InvalidArgumentException($calibrationItemArrayErrorMessage, __LINE__);
        }
        if (is_null($calibrationItem) || (is_array($calibrationItem) && empty($calibrationItem))) {
            unset($this->CalibrationItem);
        } else {
            $this->CalibrationItem = $calibrationItem;
        }
        return $this;
    }
    /**
     * Add item to CalibrationItem value
     * @throws \InvalidArgumentException
     * @param \StructType\CalibrationItem $item
     * @return \ArrayType\ArrayOfCalibrationItem
     */
    public function addToCalibrationItem(\StructType\CalibrationItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CalibrationItem) {
            throw new \InvalidArgumentException(sprintf('The CalibrationItem property can only contain items of type \StructType\CalibrationItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CalibrationItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CalibrationItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CalibrationItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CalibrationItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CalibrationItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CalibrationItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CalibrationItem
     */
    public function getAttributeName()
    {
        return 'CalibrationItem';
    }
}
