<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAssetGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfAssetGroupItem extends AbstractStructArrayBase
{
    /**
     * The AssetGroupItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssetGroupItem[]
     */
    public $AssetGroupItem;
    /**
     * Constructor method for ArrayOfAssetGroupItem
     * @uses ArrayOfAssetGroupItem::setAssetGroupItem()
     * @param \StructType\AssetGroupItem[] $assetGroupItem
     */
    public function __construct(array $assetGroupItem = array())
    {
        $this
            ->setAssetGroupItem($assetGroupItem);
    }
    /**
     * Get AssetGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssetGroupItem[]|null
     */
    public function getAssetGroupItem()
    {
        return isset($this->AssetGroupItem) ? $this->AssetGroupItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAssetGroupItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssetGroupItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssetGroupItemForArrayConstraintsFromSetAssetGroupItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAssetGroupItemAssetGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfAssetGroupItemAssetGroupItemItem instanceof \StructType\AssetGroupItem) {
                $invalidValues[] = is_object($arrayOfAssetGroupItemAssetGroupItemItem) ? get_class($arrayOfAssetGroupItemAssetGroupItemItem) : sprintf('%s(%s)', gettype($arrayOfAssetGroupItemAssetGroupItemItem), var_export($arrayOfAssetGroupItemAssetGroupItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssetGroupItem property can only contain items of type \StructType\AssetGroupItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssetGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AssetGroupItem[] $assetGroupItem
     * @return \ArrayType\ArrayOfAssetGroupItem
     */
    public function setAssetGroupItem(array $assetGroupItem = array())
    {
        // validation for constraint: array
        if ('' !== ($assetGroupItemArrayErrorMessage = self::validateAssetGroupItemForArrayConstraintsFromSetAssetGroupItem($assetGroupItem))) {
            throw new \InvalidArgumentException($assetGroupItemArrayErrorMessage, __LINE__);
        }
        if (is_null($assetGroupItem) || (is_array($assetGroupItem) && empty($assetGroupItem))) {
            unset($this->AssetGroupItem);
        } else {
            $this->AssetGroupItem = $assetGroupItem;
        }
        return $this;
    }
    /**
     * Add item to AssetGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AssetGroupItem $item
     * @return \ArrayType\ArrayOfAssetGroupItem
     */
    public function addToAssetGroupItem(\StructType\AssetGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssetGroupItem) {
            throw new \InvalidArgumentException(sprintf('The AssetGroupItem property can only contain items of type \StructType\AssetGroupItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssetGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AssetGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AssetGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AssetGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AssetGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AssetGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AssetGroupItem
     */
    public function getAttributeName()
    {
        return 'AssetGroupItem';
    }
}
