<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAnomaly_V2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfAnomaly_V2 extends AbstractStructArrayBase
{
    /**
     * The Anomaly_V2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Anomaly_V2[]
     */
    public $Anomaly_V2;
    /**
     * Constructor method for ArrayOfAnomaly_V2
     * @uses ArrayOfAnomaly_V2::setAnomaly_V2()
     * @param \StructType\Anomaly_V2[] $anomaly_V2
     */
    public function __construct(array $anomaly_V2 = array())
    {
        $this
            ->setAnomaly_V2($anomaly_V2);
    }
    /**
     * Get Anomaly_V2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Anomaly_V2[]|null
     */
    public function getAnomaly_V2()
    {
        return isset($this->Anomaly_V2) ? $this->Anomaly_V2 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAnomaly_V2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnomaly_V2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnomaly_V2ForArrayConstraintsFromSetAnomaly_V2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAnomaly_V2Anomaly_V2Item) {
            // validation for constraint: itemType
            if (!$arrayOfAnomaly_V2Anomaly_V2Item instanceof \StructType\Anomaly_V2) {
                $invalidValues[] = is_object($arrayOfAnomaly_V2Anomaly_V2Item) ? get_class($arrayOfAnomaly_V2Anomaly_V2Item) : sprintf('%s(%s)', gettype($arrayOfAnomaly_V2Anomaly_V2Item), var_export($arrayOfAnomaly_V2Anomaly_V2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Anomaly_V2 property can only contain items of type \StructType\Anomaly_V2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Anomaly_V2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly_V2[] $anomaly_V2
     * @return \ArrayType\ArrayOfAnomaly_V2
     */
    public function setAnomaly_V2(array $anomaly_V2 = array())
    {
        // validation for constraint: array
        if ('' !== ($anomaly_V2ArrayErrorMessage = self::validateAnomaly_V2ForArrayConstraintsFromSetAnomaly_V2($anomaly_V2))) {
            throw new \InvalidArgumentException($anomaly_V2ArrayErrorMessage, __LINE__);
        }
        if (is_null($anomaly_V2) || (is_array($anomaly_V2) && empty($anomaly_V2))) {
            unset($this->Anomaly_V2);
        } else {
            $this->Anomaly_V2 = $anomaly_V2;
        }
        return $this;
    }
    /**
     * Add item to Anomaly_V2 value
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly_V2 $item
     * @return \ArrayType\ArrayOfAnomaly_V2
     */
    public function addToAnomaly_V2(\StructType\Anomaly_V2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Anomaly_V2) {
            throw new \InvalidArgumentException(sprintf('The Anomaly_V2 property can only contain items of type \StructType\Anomaly_V2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Anomaly_V2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Anomaly_V2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Anomaly_V2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Anomaly_V2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Anomaly_V2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Anomaly_V2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Anomaly_V2
     */
    public function getAttributeName()
    {
        return 'Anomaly_V2';
    }
}
