<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityReportItem_V10 ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityReportItem_V10 extends AbstractStructArrayBase
{
    /**
     * The ActivityReportItem_V10
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityReportItem_V10[]
     */
    public $ActivityReportItem_V10;
    /**
     * Constructor method for ArrayOfActivityReportItem_V10
     * @uses ArrayOfActivityReportItem_V10::setActivityReportItem_V10()
     * @param \StructType\ActivityReportItem_V10[] $activityReportItem_V10
     */
    public function __construct(array $activityReportItem_V10 = array())
    {
        $this
            ->setActivityReportItem_V10($activityReportItem_V10);
    }
    /**
     * Get ActivityReportItem_V10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityReportItem_V10[]|null
     */
    public function getActivityReportItem_V10()
    {
        return isset($this->ActivityReportItem_V10) ? $this->ActivityReportItem_V10 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityReportItem_V10 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityReportItem_V10 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityReportItem_V10ForArrayConstraintsFromSetActivityReportItem_V10(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityReportItem_V10ActivityReportItem_V10Item) {
            // validation for constraint: itemType
            if (!$arrayOfActivityReportItem_V10ActivityReportItem_V10Item instanceof \StructType\ActivityReportItem_V10) {
                $invalidValues[] = is_object($arrayOfActivityReportItem_V10ActivityReportItem_V10Item) ? get_class($arrayOfActivityReportItem_V10ActivityReportItem_V10Item) : sprintf('%s(%s)', gettype($arrayOfActivityReportItem_V10ActivityReportItem_V10Item), var_export($arrayOfActivityReportItem_V10ActivityReportItem_V10Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityReportItem_V10 property can only contain items of type \StructType\ActivityReportItem_V10, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityReportItem_V10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportItem_V10[] $activityReportItem_V10
     * @return \ArrayType\ArrayOfActivityReportItem_V10
     */
    public function setActivityReportItem_V10(array $activityReportItem_V10 = array())
    {
        // validation for constraint: array
        if ('' !== ($activityReportItem_V10ArrayErrorMessage = self::validateActivityReportItem_V10ForArrayConstraintsFromSetActivityReportItem_V10($activityReportItem_V10))) {
            throw new \InvalidArgumentException($activityReportItem_V10ArrayErrorMessage, __LINE__);
        }
        if (is_null($activityReportItem_V10) || (is_array($activityReportItem_V10) && empty($activityReportItem_V10))) {
            unset($this->ActivityReportItem_V10);
        } else {
            $this->ActivityReportItem_V10 = $activityReportItem_V10;
        }
        return $this;
    }
    /**
     * Add item to ActivityReportItem_V10 value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportItem_V10 $item
     * @return \ArrayType\ArrayOfActivityReportItem_V10
     */
    public function addToActivityReportItem_V10(\StructType\ActivityReportItem_V10 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityReportItem_V10) {
            throw new \InvalidArgumentException(sprintf('The ActivityReportItem_V10 property can only contain items of type \StructType\ActivityReportItem_V10, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityReportItem_V10[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityReportItem_V10|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityReportItem_V10|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityReportItem_V10|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityReportItem_V10|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityReportItem_V10|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityReportItem_V10
     */
    public function getAttributeName()
    {
        return 'ActivityReportItem_V10';
    }
}
