<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityReportItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityReportItem extends AbstractStructArrayBase
{
    /**
     * The ActivityReportItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityReportItem[]
     */
    public $ActivityReportItem;
    /**
     * Constructor method for ArrayOfActivityReportItem
     * @uses ArrayOfActivityReportItem::setActivityReportItem()
     * @param \StructType\ActivityReportItem[] $activityReportItem
     */
    public function __construct(array $activityReportItem = array())
    {
        $this
            ->setActivityReportItem($activityReportItem);
    }
    /**
     * Get ActivityReportItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityReportItem[]|null
     */
    public function getActivityReportItem()
    {
        return isset($this->ActivityReportItem) ? $this->ActivityReportItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityReportItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityReportItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityReportItemForArrayConstraintsFromSetActivityReportItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityReportItemActivityReportItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityReportItemActivityReportItemItem instanceof \StructType\ActivityReportItem) {
                $invalidValues[] = is_object($arrayOfActivityReportItemActivityReportItemItem) ? get_class($arrayOfActivityReportItemActivityReportItemItem) : sprintf('%s(%s)', gettype($arrayOfActivityReportItemActivityReportItemItem), var_export($arrayOfActivityReportItemActivityReportItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityReportItem property can only contain items of type \StructType\ActivityReportItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityReportItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportItem[] $activityReportItem
     * @return \ArrayType\ArrayOfActivityReportItem
     */
    public function setActivityReportItem(array $activityReportItem = array())
    {
        // validation for constraint: array
        if ('' !== ($activityReportItemArrayErrorMessage = self::validateActivityReportItemForArrayConstraintsFromSetActivityReportItem($activityReportItem))) {
            throw new \InvalidArgumentException($activityReportItemArrayErrorMessage, __LINE__);
        }
        if (is_null($activityReportItem) || (is_array($activityReportItem) && empty($activityReportItem))) {
            unset($this->ActivityReportItem);
        } else {
            $this->ActivityReportItem = $activityReportItem;
        }
        return $this;
    }
    /**
     * Add item to ActivityReportItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportItem $item
     * @return \ArrayType\ArrayOfActivityReportItem
     */
    public function addToActivityReportItem(\StructType\ActivityReportItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityReportItem) {
            throw new \InvalidArgumentException(sprintf('The ActivityReportItem property can only contain items of type \StructType\ActivityReportItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityReportItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityReportItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityReportItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityReportItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityReportItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityReportItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityReportItem
     */
    public function getAttributeName()
    {
        return 'ActivityReportItem';
    }
}
