<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityReportDetailItem_V8 ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityReportDetailItem_V8 extends AbstractStructArrayBase
{
    /**
     * The ActivityReportDetailItem_V8
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityReportDetailItem_V8[]
     */
    public $ActivityReportDetailItem_V8;
    /**
     * Constructor method for ArrayOfActivityReportDetailItem_V8
     * @uses ArrayOfActivityReportDetailItem_V8::setActivityReportDetailItem_V8()
     * @param \StructType\ActivityReportDetailItem_V8[] $activityReportDetailItem_V8
     */
    public function __construct(array $activityReportDetailItem_V8 = array())
    {
        $this
            ->setActivityReportDetailItem_V8($activityReportDetailItem_V8);
    }
    /**
     * Get ActivityReportDetailItem_V8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityReportDetailItem_V8[]|null
     */
    public function getActivityReportDetailItem_V8()
    {
        return isset($this->ActivityReportDetailItem_V8) ? $this->ActivityReportDetailItem_V8 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityReportDetailItem_V8 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityReportDetailItem_V8 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityReportDetailItem_V8ForArrayConstraintsFromSetActivityReportDetailItem_V8(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityReportDetailItem_V8ActivityReportDetailItem_V8Item) {
            // validation for constraint: itemType
            if (!$arrayOfActivityReportDetailItem_V8ActivityReportDetailItem_V8Item instanceof \StructType\ActivityReportDetailItem_V8) {
                $invalidValues[] = is_object($arrayOfActivityReportDetailItem_V8ActivityReportDetailItem_V8Item) ? get_class($arrayOfActivityReportDetailItem_V8ActivityReportDetailItem_V8Item) : sprintf('%s(%s)', gettype($arrayOfActivityReportDetailItem_V8ActivityReportDetailItem_V8Item), var_export($arrayOfActivityReportDetailItem_V8ActivityReportDetailItem_V8Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityReportDetailItem_V8 property can only contain items of type \StructType\ActivityReportDetailItem_V8, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityReportDetailItem_V8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportDetailItem_V8[] $activityReportDetailItem_V8
     * @return \ArrayType\ArrayOfActivityReportDetailItem_V8
     */
    public function setActivityReportDetailItem_V8(array $activityReportDetailItem_V8 = array())
    {
        // validation for constraint: array
        if ('' !== ($activityReportDetailItem_V8ArrayErrorMessage = self::validateActivityReportDetailItem_V8ForArrayConstraintsFromSetActivityReportDetailItem_V8($activityReportDetailItem_V8))) {
            throw new \InvalidArgumentException($activityReportDetailItem_V8ArrayErrorMessage, __LINE__);
        }
        if (is_null($activityReportDetailItem_V8) || (is_array($activityReportDetailItem_V8) && empty($activityReportDetailItem_V8))) {
            unset($this->ActivityReportDetailItem_V8);
        } else {
            $this->ActivityReportDetailItem_V8 = $activityReportDetailItem_V8;
        }
        return $this;
    }
    /**
     * Add item to ActivityReportDetailItem_V8 value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportDetailItem_V8 $item
     * @return \ArrayType\ArrayOfActivityReportDetailItem_V8
     */
    public function addToActivityReportDetailItem_V8(\StructType\ActivityReportDetailItem_V8 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityReportDetailItem_V8) {
            throw new \InvalidArgumentException(sprintf('The ActivityReportDetailItem_V8 property can only contain items of type \StructType\ActivityReportDetailItem_V8, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityReportDetailItem_V8[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityReportDetailItem_V8|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityReportDetailItem_V8|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityReportDetailItem_V8|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityReportDetailItem_V8|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityReportDetailItem_V8|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityReportDetailItem_V8
     */
    public function getAttributeName()
    {
        return 'ActivityReportDetailItem_V8';
    }
}
