<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityReportDetailItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityReportDetailItem extends AbstractStructArrayBase
{
    /**
     * The ActivityReportDetailItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityReportDetailItem[]
     */
    public $ActivityReportDetailItem;
    /**
     * Constructor method for ArrayOfActivityReportDetailItem
     * @uses ArrayOfActivityReportDetailItem::setActivityReportDetailItem()
     * @param \StructType\ActivityReportDetailItem[] $activityReportDetailItem
     */
    public function __construct(array $activityReportDetailItem = array())
    {
        $this
            ->setActivityReportDetailItem($activityReportDetailItem);
    }
    /**
     * Get ActivityReportDetailItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityReportDetailItem[]|null
     */
    public function getActivityReportDetailItem()
    {
        return isset($this->ActivityReportDetailItem) ? $this->ActivityReportDetailItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityReportDetailItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityReportDetailItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityReportDetailItemForArrayConstraintsFromSetActivityReportDetailItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityReportDetailItemActivityReportDetailItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityReportDetailItemActivityReportDetailItemItem instanceof \StructType\ActivityReportDetailItem) {
                $invalidValues[] = is_object($arrayOfActivityReportDetailItemActivityReportDetailItemItem) ? get_class($arrayOfActivityReportDetailItemActivityReportDetailItemItem) : sprintf('%s(%s)', gettype($arrayOfActivityReportDetailItemActivityReportDetailItemItem), var_export($arrayOfActivityReportDetailItemActivityReportDetailItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityReportDetailItem property can only contain items of type \StructType\ActivityReportDetailItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityReportDetailItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportDetailItem[] $activityReportDetailItem
     * @return \ArrayType\ArrayOfActivityReportDetailItem
     */
    public function setActivityReportDetailItem(array $activityReportDetailItem = array())
    {
        // validation for constraint: array
        if ('' !== ($activityReportDetailItemArrayErrorMessage = self::validateActivityReportDetailItemForArrayConstraintsFromSetActivityReportDetailItem($activityReportDetailItem))) {
            throw new \InvalidArgumentException($activityReportDetailItemArrayErrorMessage, __LINE__);
        }
        if (is_null($activityReportDetailItem) || (is_array($activityReportDetailItem) && empty($activityReportDetailItem))) {
            unset($this->ActivityReportDetailItem);
        } else {
            $this->ActivityReportDetailItem = $activityReportDetailItem;
        }
        return $this;
    }
    /**
     * Add item to ActivityReportDetailItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportDetailItem $item
     * @return \ArrayType\ArrayOfActivityReportDetailItem
     */
    public function addToActivityReportDetailItem(\StructType\ActivityReportDetailItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityReportDetailItem) {
            throw new \InvalidArgumentException(sprintf('The ActivityReportDetailItem property can only contain items of type \StructType\ActivityReportDetailItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityReportDetailItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityReportDetailItem
     */
    public function getAttributeName()
    {
        return 'ActivityReportDetailItem';
    }
}
