<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityRemarkItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityRemarkItem extends AbstractStructArrayBase
{
    /**
     * The ActivityRemarkItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityRemarkItem[]
     */
    public $ActivityRemarkItem;
    /**
     * Constructor method for ArrayOfActivityRemarkItem
     * @uses ArrayOfActivityRemarkItem::setActivityRemarkItem()
     * @param \StructType\ActivityRemarkItem[] $activityRemarkItem
     */
    public function __construct(array $activityRemarkItem = array())
    {
        $this
            ->setActivityRemarkItem($activityRemarkItem);
    }
    /**
     * Get ActivityRemarkItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityRemarkItem[]|null
     */
    public function getActivityRemarkItem()
    {
        return isset($this->ActivityRemarkItem) ? $this->ActivityRemarkItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityRemarkItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityRemarkItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityRemarkItemForArrayConstraintsFromSetActivityRemarkItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityRemarkItemActivityRemarkItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityRemarkItemActivityRemarkItemItem instanceof \StructType\ActivityRemarkItem) {
                $invalidValues[] = is_object($arrayOfActivityRemarkItemActivityRemarkItemItem) ? get_class($arrayOfActivityRemarkItemActivityRemarkItemItem) : sprintf('%s(%s)', gettype($arrayOfActivityRemarkItemActivityRemarkItemItem), var_export($arrayOfActivityRemarkItemActivityRemarkItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityRemarkItem property can only contain items of type \StructType\ActivityRemarkItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityRemarkItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityRemarkItem[] $activityRemarkItem
     * @return \ArrayType\ArrayOfActivityRemarkItem
     */
    public function setActivityRemarkItem(array $activityRemarkItem = array())
    {
        // validation for constraint: array
        if ('' !== ($activityRemarkItemArrayErrorMessage = self::validateActivityRemarkItemForArrayConstraintsFromSetActivityRemarkItem($activityRemarkItem))) {
            throw new \InvalidArgumentException($activityRemarkItemArrayErrorMessage, __LINE__);
        }
        if (is_null($activityRemarkItem) || (is_array($activityRemarkItem) && empty($activityRemarkItem))) {
            unset($this->ActivityRemarkItem);
        } else {
            $this->ActivityRemarkItem = $activityRemarkItem;
        }
        return $this;
    }
    /**
     * Add item to ActivityRemarkItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityRemarkItem $item
     * @return \ArrayType\ArrayOfActivityRemarkItem
     */
    public function addToActivityRemarkItem(\StructType\ActivityRemarkItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityRemarkItem) {
            throw new \InvalidArgumentException(sprintf('The ActivityRemarkItem property can only contain items of type \StructType\ActivityRemarkItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityRemarkItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityRemarkItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityRemarkItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityRemarkItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityRemarkItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityRemarkItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityRemarkItem
     */
    public function getAttributeName()
    {
        return 'ActivityRemarkItem';
    }
}
