<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityInfo extends AbstractStructArrayBase
{
    /**
     * The ActivityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityInfo[]
     */
    public $ActivityInfo;
    /**
     * Constructor method for ArrayOfActivityInfo
     * @uses ArrayOfActivityInfo::setActivityInfo()
     * @param \StructType\ActivityInfo[] $activityInfo
     */
    public function __construct(array $activityInfo = array())
    {
        $this
            ->setActivityInfo($activityInfo);
    }
    /**
     * Get ActivityInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityInfo[]|null
     */
    public function getActivityInfo()
    {
        return isset($this->ActivityInfo) ? $this->ActivityInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityInfoForArrayConstraintsFromSetActivityInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityInfoActivityInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityInfoActivityInfoItem instanceof \StructType\ActivityInfo) {
                $invalidValues[] = is_object($arrayOfActivityInfoActivityInfoItem) ? get_class($arrayOfActivityInfoActivityInfoItem) : sprintf('%s(%s)', gettype($arrayOfActivityInfoActivityInfoItem), var_export($arrayOfActivityInfoActivityInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityInfo property can only contain items of type \StructType\ActivityInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityInfo[] $activityInfo
     * @return \ArrayType\ArrayOfActivityInfo
     */
    public function setActivityInfo(array $activityInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($activityInfoArrayErrorMessage = self::validateActivityInfoForArrayConstraintsFromSetActivityInfo($activityInfo))) {
            throw new \InvalidArgumentException($activityInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($activityInfo) || (is_array($activityInfo) && empty($activityInfo))) {
            unset($this->ActivityInfo);
        } else {
            $this->ActivityInfo = $activityInfo;
        }
        return $this;
    }
    /**
     * Add item to ActivityInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityInfo $item
     * @return \ArrayType\ArrayOfActivityInfo
     */
    public function addToActivityInfo(\StructType\ActivityInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityInfo) {
            throw new \InvalidArgumentException(sprintf('The ActivityInfo property can only contain items of type \StructType\ActivityInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityInfo
     */
    public function getAttributeName()
    {
        return 'ActivityInfo';
    }
}
