<?php

namespace GDF32\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetClientIP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GDF32\StructType\SetClientIP $parameters
     * @return \GDF32\StructType\SetClientIPResponse|bool
     */
    public function SetClientIP(\GDF32\StructType\SetClientIP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetClientIP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GDF32\StructType\SetClientIPResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
