<?php

namespace GDF32\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetKeyValues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GDF32\StructType\GetKeyValues $parameters
     * @return \GDF32\StructType\GetKeyValuesResponse|bool
     */
    public function GetKeyValues(\GDF32\StructType\GetKeyValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetKeyValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GDF32\StructType\GetKeyValuesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
