<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsingCountsForPartner StructType
 * @subpackage Structs
 */
class UsingCountsForPartner extends AbstractStructBase
{
    /**
     * The beginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $beginDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $endDate;
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $productName;
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ticket;
    /**
     * The partnerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partnerCode;
    /**
     * Constructor method for UsingCountsForPartner
     * @uses UsingCountsForPartner::setBeginDate()
     * @uses UsingCountsForPartner::setEndDate()
     * @uses UsingCountsForPartner::setProductName()
     * @uses UsingCountsForPartner::setTicket()
     * @uses UsingCountsForPartner::setPartnerCode()
     * @param string $beginDate
     * @param string $endDate
     * @param string $productName
     * @param string $ticket
     * @param string $partnerCode
     */
    public function __construct($beginDate = null, $endDate = null, $productName = null, $ticket = null, $partnerCode = null)
    {
        $this
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setProductName($productName)
            ->setTicket($ticket)
            ->setPartnerCode($partnerCode);
    }
    /**
     * Get beginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \StructType\UsingCountsForPartner
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\UsingCountsForPartner
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get productName value
     * @return string
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @uses \EnumType\ProductName::valueIsValid()
     * @uses \EnumType\ProductName::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productName
     * @return \StructType\UsingCountsForPartner
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductName::valueIsValid($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductName', is_array($productName) ? implode(', ', $productName) : var_export($productName, true), implode(', ', \EnumType\ProductName::getValidValues())), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param string $ticket
     * @return \StructType\UsingCountsForPartner
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
    /**
     * Get partnerCode value
     * @return string|null
     */
    public function getPartnerCode()
    {
        return $this->partnerCode;
    }
    /**
     * Set partnerCode value
     * @param string $partnerCode
     * @return \StructType\UsingCountsForPartner
     */
    public function setPartnerCode($partnerCode = null)
    {
        // validation for constraint: string
        if (!is_null($partnerCode) && !is_string($partnerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerCode, true), gettype($partnerCode)), __LINE__);
        }
        $this->partnerCode = $partnerCode;
        return $this;
    }
}
