<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendMailQueueAgainResponse StructType
 * @subpackage Structs
 */
class SendMailQueueAgainResponse extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * The ReceiverEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverEmail;
    /**
     * Constructor method for SendMailQueueAgainResponse
     * @uses SendMailQueueAgainResponse::setTicket()
     * @uses SendMailQueueAgainResponse::setUUID()
     * @uses SendMailQueueAgainResponse::setCorporateCode()
     * @uses SendMailQueueAgainResponse::setReceiverEmail()
     * @param string $ticket
     * @param string $uUID
     * @param string $corporateCode
     * @param string $receiverEmail
     */
    public function __construct($ticket = null, $uUID = null, $corporateCode = null, $receiverEmail = null)
    {
        $this
            ->setTicket($ticket)
            ->setUUID($uUID)
            ->setCorporateCode($corporateCode)
            ->setReceiverEmail($receiverEmail);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\SendMailQueueAgainResponse
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\SendMailQueueAgainResponse
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\SendMailQueueAgainResponse
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
    /**
     * Get ReceiverEmail value
     * @return string|null
     */
    public function getReceiverEmail()
    {
        return $this->ReceiverEmail;
    }
    /**
     * Set ReceiverEmail value
     * @param string $receiverEmail
     * @return \StructType\SendMailQueueAgainResponse
     */
    public function setReceiverEmail($receiverEmail = null)
    {
        // validation for constraint: string
        if (!is_null($receiverEmail) && !is_string($receiverEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverEmail, true), gettype($receiverEmail)), __LINE__);
        }
        $this->ReceiverEmail = $receiverEmail;
        return $this;
    }
}
