<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RejectInvoiceWithNotify StructType
 * @subpackage Structs
 */
class RejectInvoiceWithNotify extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The NotifyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotifyType;
    /**
     * Constructor method for RejectInvoiceWithNotify
     * @uses RejectInvoiceWithNotify::setTicket()
     * @uses RejectInvoiceWithNotify::setUUID()
     * @uses RejectInvoiceWithNotify::setDescription()
     * @uses RejectInvoiceWithNotify::setNotifyType()
     * @param string $ticket
     * @param string $uUID
     * @param string $description
     * @param string $notifyType
     */
    public function __construct($ticket = null, $uUID = null, $description = null, $notifyType = null)
    {
        $this
            ->setTicket($ticket)
            ->setUUID($uUID)
            ->setDescription($description)
            ->setNotifyType($notifyType);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\RejectInvoiceWithNotify
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\RejectInvoiceWithNotify
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\RejectInvoiceWithNotify
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get NotifyType value
     * @return string|null
     */
    public function getNotifyType()
    {
        return $this->NotifyType;
    }
    /**
     * Set NotifyType value
     * @param string $notifyType
     * @return \StructType\RejectInvoiceWithNotify
     */
    public function setNotifyType($notifyType = null)
    {
        // validation for constraint: string
        if (!is_null($notifyType) && !is_string($notifyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notifyType, true), gettype($notifyType)), __LINE__);
        }
        $this->NotifyType = $notifyType;
        return $this;
    }
}
