<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceCountWithDate StructType
 * @subpackage Structs
 */
class GetInvoiceCountWithDate extends AbstractStructBase
{
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $endDate;
    /**
     * The dateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dateType;
    /**
     * The getDraftInvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $getDraftInvoiceCount;
    /**
     * The withStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $withStatus;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * Constructor method for GetInvoiceCountWithDate
     * @uses GetInvoiceCountWithDate::setStartDate()
     * @uses GetInvoiceCountWithDate::setEndDate()
     * @uses GetInvoiceCountWithDate::setDateType()
     * @uses GetInvoiceCountWithDate::setGetDraftInvoiceCount()
     * @uses GetInvoiceCountWithDate::setWithStatus()
     * @uses GetInvoiceCountWithDate::setTicket()
     * @param string $startDate
     * @param string $endDate
     * @param int $dateType
     * @param bool $getDraftInvoiceCount
     * @param bool $withStatus
     * @param string $ticket
     */
    public function __construct($startDate = null, $endDate = null, $dateType = null, $getDraftInvoiceCount = null, $withStatus = null, $ticket = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setDateType($dateType)
            ->setGetDraftInvoiceCount($getDraftInvoiceCount)
            ->setWithStatus($withStatus)
            ->setTicket($ticket);
    }
    /**
     * Get startDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetInvoiceCountWithDate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\GetInvoiceCountWithDate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get dateType value
     * @return int
     */
    public function getDateType()
    {
        return $this->dateType;
    }
    /**
     * Set dateType value
     * @param int $dateType
     * @return \StructType\GetInvoiceCountWithDate
     */
    public function setDateType($dateType = null)
    {
        // validation for constraint: int
        if (!is_null($dateType) && !(is_int($dateType) || ctype_digit($dateType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dateType, true), gettype($dateType)), __LINE__);
        }
        $this->dateType = $dateType;
        return $this;
    }
    /**
     * Get getDraftInvoiceCount value
     * @return bool
     */
    public function getGetDraftInvoiceCount()
    {
        return $this->getDraftInvoiceCount;
    }
    /**
     * Set getDraftInvoiceCount value
     * @param bool $getDraftInvoiceCount
     * @return \StructType\GetInvoiceCountWithDate
     */
    public function setGetDraftInvoiceCount($getDraftInvoiceCount = null)
    {
        // validation for constraint: boolean
        if (!is_null($getDraftInvoiceCount) && !is_bool($getDraftInvoiceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getDraftInvoiceCount, true), gettype($getDraftInvoiceCount)), __LINE__);
        }
        $this->getDraftInvoiceCount = $getDraftInvoiceCount;
        return $this;
    }
    /**
     * Get withStatus value
     * @return bool
     */
    public function getWithStatus()
    {
        return $this->withStatus;
    }
    /**
     * Set withStatus value
     * @param bool $withStatus
     * @return \StructType\GetInvoiceCountWithDate
     */
    public function setWithStatus($withStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($withStatus) && !is_bool($withStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withStatus, true), gettype($withStatus)), __LINE__);
        }
        $this->withStatus = $withStatus;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetInvoiceCountWithDate
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
}
