<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEArchiveReportListWithPeriod StructType
 * @subpackage Structs
 */
class GetEArchiveReportListWithPeriod extends AbstractStructBase
{
    /**
     * The Year
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Year;
    /**
     * The Month
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Month;
    /**
     * The listType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $listType;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * Constructor method for GetEArchiveReportListWithPeriod
     * @uses GetEArchiveReportListWithPeriod::setYear()
     * @uses GetEArchiveReportListWithPeriod::setMonth()
     * @uses GetEArchiveReportListWithPeriod::setListType()
     * @uses GetEArchiveReportListWithPeriod::setTicket()
     * @uses GetEArchiveReportListWithPeriod::setCorporateCode()
     * @param int $year
     * @param int $month
     * @param string $listType
     * @param string $ticket
     * @param string $corporateCode
     */
    public function __construct($year = null, $month = null, $listType = null, $ticket = null, $corporateCode = null)
    {
        $this
            ->setYear($year)
            ->setMonth($month)
            ->setListType($listType)
            ->setTicket($ticket)
            ->setCorporateCode($corporateCode);
    }
    /**
     * Get Year value
     * @return int
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\GetEArchiveReportListWithPeriod
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
    /**
     * Get Month value
     * @return int
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \StructType\GetEArchiveReportListWithPeriod
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !(is_int($month) || ctype_digit($month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($month, true), gettype($month)), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get listType value
     * @return string
     */
    public function getListType()
    {
        return $this->listType;
    }
    /**
     * Set listType value
     * @uses \EnumType\EArchiveReportStatusListType::valueIsValid()
     * @uses \EnumType\EArchiveReportStatusListType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $listType
     * @return \StructType\GetEArchiveReportListWithPeriod
     */
    public function setListType($listType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EArchiveReportStatusListType::valueIsValid($listType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EArchiveReportStatusListType', is_array($listType) ? implode(', ', $listType) : var_export($listType, true), implode(', ', \EnumType\EArchiveReportStatusListType::getValidValues())), __LINE__);
        }
        $this->listType = $listType;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetEArchiveReportListWithPeriod
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\GetEArchiveReportListWithPeriod
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
}
