<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DBJobProcessResult StructType
 * @subpackage Structs
 */
class DBJobProcessResult extends AbstractStructBase
{
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Direction;
    /**
     * The ReceivedRecordCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceivedRecordCount;
    /**
     * The ProcessedCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProcessedCount;
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The JobName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobName;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The ResultList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceIDRecordResult
     */
    public $ResultList;
    /**
     * Constructor method for DBJobProcessResult
     * @uses DBJobProcessResult::setDirection()
     * @uses DBJobProcessResult::setReceivedRecordCount()
     * @uses DBJobProcessResult::setProcessedCount()
     * @uses DBJobProcessResult::setServiceResult()
     * @uses DBJobProcessResult::setErrorCode()
     * @uses DBJobProcessResult::setJobName()
     * @uses DBJobProcessResult::setServiceResultDescription()
     * @uses DBJobProcessResult::setResultList()
     * @param string $direction
     * @param int $receivedRecordCount
     * @param int $processedCount
     * @param string $serviceResult
     * @param int $errorCode
     * @param string $jobName
     * @param string $serviceResultDescription
     * @param \ArrayType\ArrayOfInvoiceIDRecordResult $resultList
     */
    public function __construct($direction = null, $receivedRecordCount = null, $processedCount = null, $serviceResult = null, $errorCode = null, $jobName = null, $serviceResultDescription = null, \ArrayType\ArrayOfInvoiceIDRecordResult $resultList = null)
    {
        $this
            ->setDirection($direction)
            ->setReceivedRecordCount($receivedRecordCount)
            ->setProcessedCount($processedCount)
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setJobName($jobName)
            ->setServiceResultDescription($serviceResultDescription)
            ->setResultList($resultList);
    }
    /**
     * Get Direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\DBJobProcessResult
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get ReceivedRecordCount value
     * @return int
     */
    public function getReceivedRecordCount()
    {
        return $this->ReceivedRecordCount;
    }
    /**
     * Set ReceivedRecordCount value
     * @param int $receivedRecordCount
     * @return \StructType\DBJobProcessResult
     */
    public function setReceivedRecordCount($receivedRecordCount = null)
    {
        // validation for constraint: int
        if (!is_null($receivedRecordCount) && !(is_int($receivedRecordCount) || ctype_digit($receivedRecordCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receivedRecordCount, true), gettype($receivedRecordCount)), __LINE__);
        }
        $this->ReceivedRecordCount = $receivedRecordCount;
        return $this;
    }
    /**
     * Get ProcessedCount value
     * @return int
     */
    public function getProcessedCount()
    {
        return $this->ProcessedCount;
    }
    /**
     * Set ProcessedCount value
     * @param int $processedCount
     * @return \StructType\DBJobProcessResult
     */
    public function setProcessedCount($processedCount = null)
    {
        // validation for constraint: int
        if (!is_null($processedCount) && !(is_int($processedCount) || ctype_digit($processedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processedCount, true), gettype($processedCount)), __LINE__);
        }
        $this->ProcessedCount = $processedCount;
        return $this;
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\DBJobProcessResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\DBJobProcessResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get JobName value
     * @return string|null
     */
    public function getJobName()
    {
        return $this->JobName;
    }
    /**
     * Set JobName value
     * @param string $jobName
     * @return \StructType\DBJobProcessResult
     */
    public function setJobName($jobName = null)
    {
        // validation for constraint: string
        if (!is_null($jobName) && !is_string($jobName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobName, true), gettype($jobName)), __LINE__);
        }
        $this->JobName = $jobName;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\DBJobProcessResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get ResultList value
     * @return \ArrayType\ArrayOfInvoiceIDRecordResult|null
     */
    public function getResultList()
    {
        return $this->ResultList;
    }
    /**
     * Set ResultList value
     * @param \ArrayType\ArrayOfInvoiceIDRecordResult $resultList
     * @return \StructType\DBJobProcessResult
     */
    public function setResultList(\ArrayType\ArrayOfInvoiceIDRecordResult $resultList = null)
    {
        $this->ResultList = $resultList;
        return $this;
    }
}
