<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorporateContourInfo StructType
 * @subpackage Structs
 */
class CorporateContourInfo extends AbstractStructBase
{
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productName;
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ticket;
    /**
     * The corporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $corporateCode;
    /**
     * Constructor method for CorporateContourInfo
     * @uses CorporateContourInfo::setProductName()
     * @uses CorporateContourInfo::setTicket()
     * @uses CorporateContourInfo::setCorporateCode()
     * @param string $productName
     * @param string $ticket
     * @param string $corporateCode
     */
    public function __construct($productName = null, $ticket = null, $corporateCode = null)
    {
        $this
            ->setProductName($productName)
            ->setTicket($ticket)
            ->setCorporateCode($corporateCode);
    }
    /**
     * Get productName value
     * @return string
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @uses \EnumType\ProductName::valueIsValid()
     * @uses \EnumType\ProductName::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productName
     * @return \StructType\CorporateContourInfo
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductName::valueIsValid($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductName', is_array($productName) ? implode(', ', $productName) : var_export($productName, true), implode(', ', \EnumType\ProductName::getValidValues())), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param string $ticket
     * @return \StructType\CorporateContourInfo
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
    /**
     * Get corporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->corporateCode;
    }
    /**
     * Set corporateCode value
     * @param string $corporateCode
     * @return \StructType\CorporateContourInfo
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->corporateCode = $corporateCode;
        return $this;
    }
}
