<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContourInfo StructType
 * @subpackage Structs
 */
class ContourInfo extends AbstractStructBase
{
    /**
     * The AgreementAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AgreementAmount;
    /**
     * The UsageAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UsageAmount;
    /**
     * The NetAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetAmount;
    /**
     * The VknTckn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VknTckn;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * The PartnerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerCode;
    /**
     * The AgreementProductGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgreementProductGroup;
    /**
     * Constructor method for ContourInfo
     * @uses ContourInfo::setAgreementAmount()
     * @uses ContourInfo::setUsageAmount()
     * @uses ContourInfo::setNetAmount()
     * @uses ContourInfo::setVknTckn()
     * @uses ContourInfo::setCorporateCode()
     * @uses ContourInfo::setPartnerCode()
     * @uses ContourInfo::setAgreementProductGroup()
     * @param float $agreementAmount
     * @param int $usageAmount
     * @param float $netAmount
     * @param string $vknTckn
     * @param string $corporateCode
     * @param string $partnerCode
     * @param string $agreementProductGroup
     */
    public function __construct($agreementAmount = null, $usageAmount = null, $netAmount = null, $vknTckn = null, $corporateCode = null, $partnerCode = null, $agreementProductGroup = null)
    {
        $this
            ->setAgreementAmount($agreementAmount)
            ->setUsageAmount($usageAmount)
            ->setNetAmount($netAmount)
            ->setVknTckn($vknTckn)
            ->setCorporateCode($corporateCode)
            ->setPartnerCode($partnerCode)
            ->setAgreementProductGroup($agreementProductGroup);
    }
    /**
     * Get AgreementAmount value
     * @return float
     */
    public function getAgreementAmount()
    {
        return $this->AgreementAmount;
    }
    /**
     * Set AgreementAmount value
     * @param float $agreementAmount
     * @return \StructType\ContourInfo
     */
    public function setAgreementAmount($agreementAmount = null)
    {
        // validation for constraint: float
        if (!is_null($agreementAmount) && !(is_float($agreementAmount) || is_numeric($agreementAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agreementAmount, true), gettype($agreementAmount)), __LINE__);
        }
        $this->AgreementAmount = $agreementAmount;
        return $this;
    }
    /**
     * Get UsageAmount value
     * @return int
     */
    public function getUsageAmount()
    {
        return $this->UsageAmount;
    }
    /**
     * Set UsageAmount value
     * @param int $usageAmount
     * @return \StructType\ContourInfo
     */
    public function setUsageAmount($usageAmount = null)
    {
        // validation for constraint: int
        if (!is_null($usageAmount) && !(is_int($usageAmount) || ctype_digit($usageAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usageAmount, true), gettype($usageAmount)), __LINE__);
        }
        $this->UsageAmount = $usageAmount;
        return $this;
    }
    /**
     * Get NetAmount value
     * @return float
     */
    public function getNetAmount()
    {
        return $this->NetAmount;
    }
    /**
     * Set NetAmount value
     * @param float $netAmount
     * @return \StructType\ContourInfo
     */
    public function setNetAmount($netAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netAmount) && !(is_float($netAmount) || is_numeric($netAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netAmount, true), gettype($netAmount)), __LINE__);
        }
        $this->NetAmount = $netAmount;
        return $this;
    }
    /**
     * Get VknTckn value
     * @return string|null
     */
    public function getVknTckn()
    {
        return $this->VknTckn;
    }
    /**
     * Set VknTckn value
     * @param string $vknTckn
     * @return \StructType\ContourInfo
     */
    public function setVknTckn($vknTckn = null)
    {
        // validation for constraint: string
        if (!is_null($vknTckn) && !is_string($vknTckn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vknTckn, true), gettype($vknTckn)), __LINE__);
        }
        $this->VknTckn = $vknTckn;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\ContourInfo
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
    /**
     * Get PartnerCode value
     * @return string|null
     */
    public function getPartnerCode()
    {
        return $this->PartnerCode;
    }
    /**
     * Set PartnerCode value
     * @param string $partnerCode
     * @return \StructType\ContourInfo
     */
    public function setPartnerCode($partnerCode = null)
    {
        // validation for constraint: string
        if (!is_null($partnerCode) && !is_string($partnerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerCode, true), gettype($partnerCode)), __LINE__);
        }
        $this->PartnerCode = $partnerCode;
        return $this;
    }
    /**
     * Get AgreementProductGroup value
     * @return string|null
     */
    public function getAgreementProductGroup()
    {
        return $this->AgreementProductGroup;
    }
    /**
     * Set AgreementProductGroup value
     * @param string $agreementProductGroup
     * @return \StructType\ContourInfo
     */
    public function setAgreementProductGroup($agreementProductGroup = null)
    {
        // validation for constraint: string
        if (!is_null($agreementProductGroup) && !is_string($agreementProductGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agreementProductGroup, true), gettype($agreementProductGroup)), __LINE__);
        }
        $this->AgreementProductGroup = $agreementProductGroup;
        return $this;
    }
}
