<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckCustomerTaxId StructType
 * @subpackage Structs
 */
class CheckCustomerTaxId extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The TaxIdOrPersonalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxIdOrPersonalId;
    /**
     * Constructor method for CheckCustomerTaxId
     * @uses CheckCustomerTaxId::setTicket()
     * @uses CheckCustomerTaxId::setTaxIdOrPersonalId()
     * @param string $ticket
     * @param string $taxIdOrPersonalId
     */
    public function __construct($ticket = null, $taxIdOrPersonalId = null)
    {
        $this
            ->setTicket($ticket)
            ->setTaxIdOrPersonalId($taxIdOrPersonalId);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CheckCustomerTaxId
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get TaxIdOrPersonalId value
     * @return string|null
     */
    public function getTaxIdOrPersonalId()
    {
        return $this->TaxIdOrPersonalId;
    }
    /**
     * Set TaxIdOrPersonalId value
     * @param string $taxIdOrPersonalId
     * @return \StructType\CheckCustomerTaxId
     */
    public function setTaxIdOrPersonalId($taxIdOrPersonalId = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdOrPersonalId) && !is_string($taxIdOrPersonalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdOrPersonalId, true), gettype($taxIdOrPersonalId)), __LINE__);
        }
        $this->TaxIdOrPersonalId = $taxIdOrPersonalId;
        return $this;
    }
}
