<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelInvoiceDataForTaxFree StructType
 * @subpackage Structs
 */
class CancelInvoiceDataForTaxFree extends AbstractStructBase
{
    /**
     * The CancelInvoiceDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelInvoiceDateTime;
    /**
     * The ExpenseSlipDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpenseSlipDate;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The ExpenseSlipNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpenseSlipNumber;
    /**
     * Constructor method for CancelInvoiceDataForTaxFree
     * @uses CancelInvoiceDataForTaxFree::setCancelInvoiceDateTime()
     * @uses CancelInvoiceDataForTaxFree::setExpenseSlipDate()
     * @uses CancelInvoiceDataForTaxFree::setTicket()
     * @uses CancelInvoiceDataForTaxFree::setUUID()
     * @uses CancelInvoiceDataForTaxFree::setExpenseSlipNumber()
     * @param string $cancelInvoiceDateTime
     * @param string $expenseSlipDate
     * @param string $ticket
     * @param string $uUID
     * @param string $expenseSlipNumber
     */
    public function __construct($cancelInvoiceDateTime = null, $expenseSlipDate = null, $ticket = null, $uUID = null, $expenseSlipNumber = null)
    {
        $this
            ->setCancelInvoiceDateTime($cancelInvoiceDateTime)
            ->setExpenseSlipDate($expenseSlipDate)
            ->setTicket($ticket)
            ->setUUID($uUID)
            ->setExpenseSlipNumber($expenseSlipNumber);
    }
    /**
     * Get CancelInvoiceDateTime value
     * @return string
     */
    public function getCancelInvoiceDateTime()
    {
        return $this->CancelInvoiceDateTime;
    }
    /**
     * Set CancelInvoiceDateTime value
     * @param string $cancelInvoiceDateTime
     * @return \StructType\CancelInvoiceDataForTaxFree
     */
    public function setCancelInvoiceDateTime($cancelInvoiceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($cancelInvoiceDateTime) && !is_string($cancelInvoiceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelInvoiceDateTime, true), gettype($cancelInvoiceDateTime)), __LINE__);
        }
        $this->CancelInvoiceDateTime = $cancelInvoiceDateTime;
        return $this;
    }
    /**
     * Get ExpenseSlipDate value
     * @return string
     */
    public function getExpenseSlipDate()
    {
        return $this->ExpenseSlipDate;
    }
    /**
     * Set ExpenseSlipDate value
     * @param string $expenseSlipDate
     * @return \StructType\CancelInvoiceDataForTaxFree
     */
    public function setExpenseSlipDate($expenseSlipDate = null)
    {
        // validation for constraint: string
        if (!is_null($expenseSlipDate) && !is_string($expenseSlipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expenseSlipDate, true), gettype($expenseSlipDate)), __LINE__);
        }
        $this->ExpenseSlipDate = $expenseSlipDate;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CancelInvoiceDataForTaxFree
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\CancelInvoiceDataForTaxFree
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get ExpenseSlipNumber value
     * @return string|null
     */
    public function getExpenseSlipNumber()
    {
        return $this->ExpenseSlipNumber;
    }
    /**
     * Set ExpenseSlipNumber value
     * @param string $expenseSlipNumber
     * @return \StructType\CancelInvoiceDataForTaxFree
     */
    public function setExpenseSlipNumber($expenseSlipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($expenseSlipNumber) && !is_string($expenseSlipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expenseSlipNumber, true), gettype($expenseSlipNumber)), __LINE__);
        }
        $this->ExpenseSlipNumber = $expenseSlipNumber;
        return $this;
    }
}
