<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelEArchiveInvoice StructType
 * @subpackage Structs
 */
class CancelEArchiveInvoice extends AbstractStructBase
{
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAmount;
    /**
     * The CancelDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CancelDate;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for CancelEArchiveInvoice
     * @uses CancelEArchiveInvoice::setTotalAmount()
     * @uses CancelEArchiveInvoice::setCancelDate()
     * @uses CancelEArchiveInvoice::setTicket()
     * @uses CancelEArchiveInvoice::setValue()
     * @uses CancelEArchiveInvoice::setType()
     * @param float $totalAmount
     * @param string $cancelDate
     * @param string $ticket
     * @param string $value
     * @param string $type
     */
    public function __construct($totalAmount = null, $cancelDate = null, $ticket = null, $value = null, $type = null)
    {
        $this
            ->setTotalAmount($totalAmount)
            ->setCancelDate($cancelDate)
            ->setTicket($ticket)
            ->setValue($value)
            ->setType($type);
    }
    /**
     * Get TotalAmount value
     * @return float
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\CancelEArchiveInvoice
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get CancelDate value
     * @return string
     */
    public function getCancelDate()
    {
        return $this->CancelDate;
    }
    /**
     * Set CancelDate value
     * @param string $cancelDate
     * @return \StructType\CancelEArchiveInvoice
     */
    public function setCancelDate($cancelDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelDate) && !is_string($cancelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelDate, true), gettype($cancelDate)), __LINE__);
        }
        $this->CancelDate = $cancelDate;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CancelEArchiveInvoice
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\CancelEArchiveInvoice
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CancelEArchiveInvoice
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
