<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationResponsePackResult StructType
 * @subpackage Structs
 */
class ApplicationResponsePackResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The Invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Invoices;
    /**
     * Constructor method for ApplicationResponsePackResult
     * @uses ApplicationResponsePackResult::setServiceResult()
     * @uses ApplicationResponsePackResult::setErrorCode()
     * @uses ApplicationResponsePackResult::setServiceResultDescription()
     * @uses ApplicationResponsePackResult::setInvoices()
     * @param string $serviceResult
     * @param int $errorCode
     * @param string $serviceResultDescription
     * @param \ArrayType\ArrayOfString $invoices
     */
    public function __construct($serviceResult = null, $errorCode = null, $serviceResultDescription = null, \ArrayType\ArrayOfString $invoices = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription)
            ->setInvoices($invoices);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\ApplicationResponsePackResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\ApplicationResponsePackResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\ApplicationResponsePackResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get Invoices value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getInvoices()
    {
        return $this->Invoices;
    }
    /**
     * Set Invoices value
     * @param \ArrayType\ArrayOfString $invoices
     * @return \StructType\ApplicationResponsePackResult
     */
    public function setInvoices(\ArrayType\ArrayOfString $invoices = null)
    {
        $this->Invoices = $invoices;
        return $this;
    }
}
