<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UploadFromArchiveOutgoing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFromArchiveOutgoing $parameters
     * @return \StructType\UploadFromArchiveOutgoingResponse|bool
     */
    public function UploadFromArchiveOutgoing(\StructType\UploadFromArchiveOutgoing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFromArchiveOutgoing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFromArchiveUBLOutgoing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFromArchiveUBLOutgoing $parameters
     * @return \StructType\UploadFromArchiveUBLOutgoingResponse|bool
     */
    public function UploadFromArchiveUBLOutgoing(\StructType\UploadFromArchiveUBLOutgoing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFromArchiveUBLOutgoing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFromArchiveEnvelopeOutgoing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFromArchiveEnvelopeOutgoing $parameters
     * @return \StructType\UploadFromArchiveEnvelopeOutgoingResponse|bool
     */
    public function UploadFromArchiveEnvelopeOutgoing(\StructType\UploadFromArchiveEnvelopeOutgoing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFromArchiveEnvelopeOutgoing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFromArchiveIncoming
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFromArchiveIncoming $parameters
     * @return \StructType\UploadFromArchiveIncomingResponse|bool
     */
    public function UploadFromArchiveIncoming(\StructType\UploadFromArchiveIncoming $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFromArchiveIncoming($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFromArchiveUBLIncoming
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFromArchiveUBLIncoming $parameters
     * @return \StructType\UploadFromArchiveUBLIncomingResponse|bool
     */
    public function UploadFromArchiveUBLIncoming(\StructType\UploadFromArchiveUBLIncoming $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFromArchiveUBLIncoming($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFromArchiveEnvelopeIncoming
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFromArchiveEnvelopeIncoming $parameters
     * @return \StructType\UploadFromArchiveEnvelopeIncomingResponse|bool
     */
    public function UploadFromArchiveEnvelopeIncoming(\StructType\UploadFromArchiveEnvelopeIncoming $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFromArchiveEnvelopeIncoming($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFromArchiveEArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFromArchiveEArchive $parameters
     * @return \StructType\UploadFromArchiveEArchiveResponse|bool
     */
    public function UploadFromArchiveEArchive(\StructType\UploadFromArchiveEArchive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFromArchiveEArchive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFromArchiveEArchiveReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFromArchiveEArchiveReport $parameters
     * @return \StructType\UploadFromArchiveEArchiveReportResponse|bool
     */
    public function UploadFromArchiveEArchiveReport(\StructType\UploadFromArchiveEArchiveReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFromArchiveEArchiveReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UploadFromArchiveEArchiveReportResponse|\StructType\UploadFromArchiveEArchiveResponse|\StructType\UploadFromArchiveEnvelopeIncomingResponse|\StructType\UploadFromArchiveEnvelopeOutgoingResponse|\StructType\UploadFromArchiveIncomingResponse|\StructType\UploadFromArchiveOutgoingResponse|\StructType\UploadFromArchiveUBLIncomingResponse|\StructType\UploadFromArchiveUBLOutgoingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
