<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Partner ServiceType
 * @subpackage Services
 */
class Partner extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PartnerAndCorporateContourInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PartnerAndCorporateContourInfo $parameters
     * @return \StructType\PartnerAndCorporateContourInfoResponse|bool
     */
    public function PartnerAndCorporateContourInfo(\StructType\PartnerAndCorporateContourInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PartnerAndCorporateContourInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PartnerAndCorporateContourInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
