<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckGibStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckGibStatus $parameters
     * @return \StructType\CheckGibStatusResponse|bool
     */
    public function CheckGibStatus(\StructType\CheckGibStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckGibStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckInvoiceState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckInvoiceState $parameters
     * @return \StructType\CheckInvoiceStateResponse|bool
     */
    public function CheckInvoiceState(\StructType\CheckInvoiceState $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckInvoiceState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckEArchiveInvoiceState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckEArchiveInvoiceState $parameters
     * @return \StructType\CheckEArchiveInvoiceStateResponse|bool
     */
    public function CheckEArchiveInvoiceState(\StructType\CheckEArchiveInvoiceState $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckEArchiveInvoiceState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckEArchiveReportState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckEArchiveReportState $parameters
     * @return \StructType\CheckEArchiveReportStateResponse|bool
     */
    public function CheckEArchiveReportState(\StructType\CheckEArchiveReportState $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckEArchiveReportState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CheckInvoiceStateWithReconciliationID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckInvoiceStateWithReconciliationID $parameters
     * @return \StructType\CheckInvoiceStateWithReconciliationIDResponse|bool
     */
    public function CheckInvoiceStateWithReconciliationID(\StructType\CheckInvoiceStateWithReconciliationID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckInvoiceStateWithReconciliationID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckEnvelopeState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckEnvelopeState $parameters
     * @return \StructType\CheckEnvelopeStateResponse|bool
     */
    public function CheckEnvelopeState(\StructType\CheckEnvelopeState $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckEnvelopeState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckTaxIdListFromExcelFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckTaxIdListFromExcelFile $parameters
     * @return \StructType\CheckTaxIdListFromExcelFileResponse|bool
     */
    public function CheckTaxIdListFromExcelFile(\StructType\CheckTaxIdListFromExcelFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckTaxIdListFromExcelFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckCustomerTaxId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckCustomerTaxId $parameters
     * @return \StructType\CheckCustomerTaxIdResponse|bool
     */
    public function CheckCustomerTaxId(\StructType\CheckCustomerTaxId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckCustomerTaxId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckCustomerTaxIdbyDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckCustomerTaxIdbyDate $parameters
     * @return \StructType\CheckCustomerTaxIdbyDateResponse|bool
     */
    public function CheckCustomerTaxIdbyDate(\StructType\CheckCustomerTaxIdbyDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckCustomerTaxIdbyDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckCustomerTaxIdbyDateResponse|\StructType\CheckCustomerTaxIdResponse|\StructType\CheckEArchiveInvoiceStateResponse|\StructType\CheckEArchiveReportStateResponse|\StructType\CheckEnvelopeStateResponse|\StructType\CheckGibStatusResponse|\StructType\CheckInvoiceStateResponse|\StructType\CheckInvoiceStateWithReconciliationIDResponse|\StructType\CheckTaxIdListFromExcelFileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
