<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelEArchiveInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelEArchiveInvoice $parameters
     * @return \StructType\CancelEArchiveInvoiceResponse|bool
     */
    public function CancelEArchiveInvoice(\StructType\CancelEArchiveInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelEArchiveInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelInvoiceNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelInvoiceNumber $parameters
     * @return \StructType\CancelInvoiceNumberResponse|bool
     */
    public function CancelInvoiceNumber(\StructType\CancelInvoiceNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelInvoiceNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelEArchiveInvoiceStringDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelEArchiveInvoiceStringDate $parameters
     * @return \StructType\CancelEArchiveInvoiceStringDateResponse|bool
     */
    public function CancelEArchiveInvoiceStringDate(\StructType\CancelEArchiveInvoiceStringDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelEArchiveInvoiceStringDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CancelEArchiveInvoiceStringDateAndAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelEArchiveInvoiceStringDateAndAmount $parameters
     * @return \StructType\CancelEArchiveInvoiceStringDateAndAmountResponse|bool
     */
    public function CancelEArchiveInvoiceStringDateAndAmount(\StructType\CancelEArchiveInvoiceStringDateAndAmount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelEArchiveInvoiceStringDateAndAmount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelInvoice $parameters
     * @return \StructType\CancelInvoiceResponse|bool
     */
    public function CancelInvoice(\StructType\CancelInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelInvoiceDataForTaxFree
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelInvoiceDataForTaxFree $parameters
     * @return \StructType\CancelInvoiceDataForTaxFreeResponse|bool
     */
    public function CancelInvoiceDataForTaxFree(\StructType\CancelInvoiceDataForTaxFree $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelInvoiceDataForTaxFree($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelEArchiveInvoiceResponse|\StructType\CancelEArchiveInvoiceStringDateAndAmountResponse|\StructType\CancelEArchiveInvoiceStringDateResponse|\StructType\CancelInvoiceDataForTaxFreeResponse|\StructType\CancelInvoiceNumberResponse|\StructType\CancelInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
