<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceStateResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceStateResult extends AbstractStructArrayBase
{
    /**
     * The InvoiceStateResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceStateResult[]
     */
    public $InvoiceStateResult;
    /**
     * Constructor method for ArrayOfInvoiceStateResult
     * @uses ArrayOfInvoiceStateResult::setInvoiceStateResult()
     * @param \StructType\InvoiceStateResult[] $invoiceStateResult
     */
    public function __construct(array $invoiceStateResult = array())
    {
        $this
            ->setInvoiceStateResult($invoiceStateResult);
    }
    /**
     * Get InvoiceStateResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceStateResult[]|null
     */
    public function getInvoiceStateResult()
    {
        return isset($this->InvoiceStateResult) ? $this->InvoiceStateResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceStateResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceStateResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceStateResultForArrayConstraintsFromSetInvoiceStateResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceStateResultInvoiceStateResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceStateResultInvoiceStateResultItem instanceof \StructType\InvoiceStateResult) {
                $invalidValues[] = is_object($arrayOfInvoiceStateResultInvoiceStateResultItem) ? get_class($arrayOfInvoiceStateResultInvoiceStateResultItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceStateResultInvoiceStateResultItem), var_export($arrayOfInvoiceStateResultInvoiceStateResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceStateResult property can only contain items of type \StructType\InvoiceStateResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceStateResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceStateResult[] $invoiceStateResult
     * @return \ArrayType\ArrayOfInvoiceStateResult
     */
    public function setInvoiceStateResult(array $invoiceStateResult = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceStateResultArrayErrorMessage = self::validateInvoiceStateResultForArrayConstraintsFromSetInvoiceStateResult($invoiceStateResult))) {
            throw new \InvalidArgumentException($invoiceStateResultArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceStateResult) || (is_array($invoiceStateResult) && empty($invoiceStateResult))) {
            unset($this->InvoiceStateResult);
        } else {
            $this->InvoiceStateResult = $invoiceStateResult;
        }
        return $this;
    }
    /**
     * Add item to InvoiceStateResult value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceStateResult $item
     * @return \ArrayType\ArrayOfInvoiceStateResult
     */
    public function addToInvoiceStateResult(\StructType\InvoiceStateResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceStateResult) {
            throw new \InvalidArgumentException(sprintf('The InvoiceStateResult property can only contain items of type \StructType\InvoiceStateResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceStateResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceStateResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceStateResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceStateResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceStateResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceStateResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceStateResult
     */
    public function getAttributeName()
    {
        return 'InvoiceStateResult';
    }
}
