<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReSendInvoiceData StructType
 * @subpackage Structs
 */
class ReSendInvoiceData extends AbstractStructBase
{
    /**
     * The FileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FileType;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The InvoiceRawData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceRawData;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * The MapCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MapCode;
    /**
     * The ReceiverPostboxName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPostboxName;
    /**
     * Constructor method for ReSendInvoiceData
     * @uses ReSendInvoiceData::setFileType()
     * @uses ReSendInvoiceData::setTicket()
     * @uses ReSendInvoiceData::setUUID()
     * @uses ReSendInvoiceData::setInvoiceRawData()
     * @uses ReSendInvoiceData::setCorporateCode()
     * @uses ReSendInvoiceData::setMapCode()
     * @uses ReSendInvoiceData::setReceiverPostboxName()
     * @param string $fileType
     * @param string $ticket
     * @param string $uUID
     * @param string $invoiceRawData
     * @param string $corporateCode
     * @param string $mapCode
     * @param string $receiverPostboxName
     */
    public function __construct($fileType = null, $ticket = null, $uUID = null, $invoiceRawData = null, $corporateCode = null, $mapCode = null, $receiverPostboxName = null)
    {
        $this
            ->setFileType($fileType)
            ->setTicket($ticket)
            ->setUUID($uUID)
            ->setInvoiceRawData($invoiceRawData)
            ->setCorporateCode($corporateCode)
            ->setMapCode($mapCode)
            ->setReceiverPostboxName($receiverPostboxName);
    }
    /**
     * Get FileType value
     * @return string
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @uses \EnumType\File::valueIsValid()
     * @uses \EnumType\File::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileType
     * @return \StructType\ReSendInvoiceData
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\File::valueIsValid($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\File', is_array($fileType) ? implode(', ', $fileType) : var_export($fileType, true), implode(', ', \EnumType\File::getValidValues())), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\ReSendInvoiceData
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\ReSendInvoiceData
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get InvoiceRawData value
     * @return string|null
     */
    public function getInvoiceRawData()
    {
        return $this->InvoiceRawData;
    }
    /**
     * Set InvoiceRawData value
     * @param string $invoiceRawData
     * @return \StructType\ReSendInvoiceData
     */
    public function setInvoiceRawData($invoiceRawData = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceRawData) && !is_string($invoiceRawData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceRawData, true), gettype($invoiceRawData)), __LINE__);
        }
        $this->InvoiceRawData = $invoiceRawData;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\ReSendInvoiceData
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
    /**
     * Get MapCode value
     * @return string|null
     */
    public function getMapCode()
    {
        return $this->MapCode;
    }
    /**
     * Set MapCode value
     * @param string $mapCode
     * @return \StructType\ReSendInvoiceData
     */
    public function setMapCode($mapCode = null)
    {
        // validation for constraint: string
        if (!is_null($mapCode) && !is_string($mapCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mapCode, true), gettype($mapCode)), __LINE__);
        }
        $this->MapCode = $mapCode;
        return $this;
    }
    /**
     * Get ReceiverPostboxName value
     * @return string|null
     */
    public function getReceiverPostboxName()
    {
        return $this->ReceiverPostboxName;
    }
    /**
     * Set ReceiverPostboxName value
     * @param string $receiverPostboxName
     * @return \StructType\ReSendInvoiceData
     */
    public function setReceiverPostboxName($receiverPostboxName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPostboxName) && !is_string($receiverPostboxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPostboxName, true), gettype($receiverPostboxName)), __LINE__);
        }
        $this->ReceiverPostboxName = $receiverPostboxName;
        return $this;
    }
}
