<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessDataWithCode StructType
 * @subpackage Structs
 */
class ProcessDataWithCode extends AbstractStructBase
{
    /**
     * The fileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $fileType;
    /**
     * The direction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $direction;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The fileContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileContent;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * Constructor method for ProcessDataWithCode
     * @uses ProcessDataWithCode::setFileType()
     * @uses ProcessDataWithCode::setDirection()
     * @uses ProcessDataWithCode::setTicket()
     * @uses ProcessDataWithCode::setFileContent()
     * @uses ProcessDataWithCode::setCode()
     * @param string $fileType
     * @param string $direction
     * @param string $ticket
     * @param string $fileContent
     * @param string $code
     */
    public function __construct($fileType = null, $direction = null, $ticket = null, $fileContent = null, $code = null)
    {
        $this
            ->setFileType($fileType)
            ->setDirection($direction)
            ->setTicket($ticket)
            ->setFileContent($fileContent)
            ->setCode($code);
    }
    /**
     * Get fileType value
     * @return string
     */
    public function getFileType()
    {
        return $this->fileType;
    }
    /**
     * Set fileType value
     * @uses \EnumType\UUIDFileType::valueIsValid()
     * @uses \EnumType\UUIDFileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileType
     * @return \StructType\ProcessDataWithCode
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UUIDFileType::valueIsValid($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UUIDFileType', is_array($fileType) ? implode(', ', $fileType) : var_export($fileType, true), implode(', ', \EnumType\UUIDFileType::getValidValues())), __LINE__);
        }
        $this->fileType = $fileType;
        return $this;
    }
    /**
     * Get direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\ProcessDataWithCode
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->direction = $direction;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\ProcessDataWithCode
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get fileContent value
     * @return string|null
     */
    public function getFileContent()
    {
        return $this->fileContent;
    }
    /**
     * Set fileContent value
     * @param string $fileContent
     * @return \StructType\ProcessDataWithCode
     */
    public function setFileContent($fileContent = null)
    {
        // validation for constraint: string
        if (!is_null($fileContent) && !is_string($fileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContent, true), gettype($fileContent)), __LINE__);
        }
        $this->fileContent = $fileContent;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\ProcessDataWithCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
}
