<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceSummaryResult StructType
 * @subpackage Structs
 */
class InvoiceSummaryResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The OutgoingInvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OutgoingInvoiceCount;
    /**
     * The IncomingInvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IncomingInvoiceCount;
    /**
     * The OutgoingInvoiceSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceSummary
     */
    public $OutgoingInvoiceSummary;
    /**
     * The IncomingInvoiceSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceSummary
     */
    public $IncomingInvoiceSummary;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * Constructor method for InvoiceSummaryResult
     * @uses InvoiceSummaryResult::setServiceResult()
     * @uses InvoiceSummaryResult::setErrorCode()
     * @uses InvoiceSummaryResult::setOutgoingInvoiceCount()
     * @uses InvoiceSummaryResult::setIncomingInvoiceCount()
     * @uses InvoiceSummaryResult::setOutgoingInvoiceSummary()
     * @uses InvoiceSummaryResult::setIncomingInvoiceSummary()
     * @uses InvoiceSummaryResult::setServiceResultDescription()
     * @param string $serviceResult
     * @param int $errorCode
     * @param int $outgoingInvoiceCount
     * @param int $incomingInvoiceCount
     * @param \ArrayType\ArrayOfInvoiceSummary $outgoingInvoiceSummary
     * @param \ArrayType\ArrayOfInvoiceSummary $incomingInvoiceSummary
     * @param string $serviceResultDescription
     */
    public function __construct($serviceResult = null, $errorCode = null, $outgoingInvoiceCount = null, $incomingInvoiceCount = null, \ArrayType\ArrayOfInvoiceSummary $outgoingInvoiceSummary = null, \ArrayType\ArrayOfInvoiceSummary $incomingInvoiceSummary = null, $serviceResultDescription = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setOutgoingInvoiceCount($outgoingInvoiceCount)
            ->setIncomingInvoiceCount($incomingInvoiceCount)
            ->setOutgoingInvoiceSummary($outgoingInvoiceSummary)
            ->setIncomingInvoiceSummary($incomingInvoiceSummary)
            ->setServiceResultDescription($serviceResultDescription);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\InvoiceSummaryResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\InvoiceSummaryResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get OutgoingInvoiceCount value
     * @return int
     */
    public function getOutgoingInvoiceCount()
    {
        return $this->OutgoingInvoiceCount;
    }
    /**
     * Set OutgoingInvoiceCount value
     * @param int $outgoingInvoiceCount
     * @return \StructType\InvoiceSummaryResult
     */
    public function setOutgoingInvoiceCount($outgoingInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($outgoingInvoiceCount) && !(is_int($outgoingInvoiceCount) || ctype_digit($outgoingInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outgoingInvoiceCount, true), gettype($outgoingInvoiceCount)), __LINE__);
        }
        $this->OutgoingInvoiceCount = $outgoingInvoiceCount;
        return $this;
    }
    /**
     * Get IncomingInvoiceCount value
     * @return int
     */
    public function getIncomingInvoiceCount()
    {
        return $this->IncomingInvoiceCount;
    }
    /**
     * Set IncomingInvoiceCount value
     * @param int $incomingInvoiceCount
     * @return \StructType\InvoiceSummaryResult
     */
    public function setIncomingInvoiceCount($incomingInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($incomingInvoiceCount) && !(is_int($incomingInvoiceCount) || ctype_digit($incomingInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($incomingInvoiceCount, true), gettype($incomingInvoiceCount)), __LINE__);
        }
        $this->IncomingInvoiceCount = $incomingInvoiceCount;
        return $this;
    }
    /**
     * Get OutgoingInvoiceSummary value
     * @return \ArrayType\ArrayOfInvoiceSummary|null
     */
    public function getOutgoingInvoiceSummary()
    {
        return $this->OutgoingInvoiceSummary;
    }
    /**
     * Set OutgoingInvoiceSummary value
     * @param \ArrayType\ArrayOfInvoiceSummary $outgoingInvoiceSummary
     * @return \StructType\InvoiceSummaryResult
     */
    public function setOutgoingInvoiceSummary(\ArrayType\ArrayOfInvoiceSummary $outgoingInvoiceSummary = null)
    {
        $this->OutgoingInvoiceSummary = $outgoingInvoiceSummary;
        return $this;
    }
    /**
     * Get IncomingInvoiceSummary value
     * @return \ArrayType\ArrayOfInvoiceSummary|null
     */
    public function getIncomingInvoiceSummary()
    {
        return $this->IncomingInvoiceSummary;
    }
    /**
     * Set IncomingInvoiceSummary value
     * @param \ArrayType\ArrayOfInvoiceSummary $incomingInvoiceSummary
     * @return \StructType\InvoiceSummaryResult
     */
    public function setIncomingInvoiceSummary(\ArrayType\ArrayOfInvoiceSummary $incomingInvoiceSummary = null)
    {
        $this->IncomingInvoiceSummary = $incomingInvoiceSummary;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\InvoiceSummaryResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
}
