<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoicePW StructType
 * @subpackage Structs
 */
class GetInvoicePW extends AbstractStructBase
{
    /**
     * The direction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $direction;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * Constructor method for GetInvoicePW
     * @uses GetInvoicePW::setDirection()
     * @uses GetInvoicePW::setTicket()
     * @uses GetInvoicePW::setUUID()
     * @param string $direction
     * @param string $ticket
     * @param string $uUID
     */
    public function __construct($direction = null, $ticket = null, $uUID = null)
    {
        $this
            ->setDirection($direction)
            ->setTicket($ticket)
            ->setUUID($uUID);
    }
    /**
     * Get direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\GetInvoicePW
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->direction = $direction;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetInvoicePW
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\GetInvoicePW
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
}
