<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EInvoiceCustomerListUpdateResult StructType
 * @subpackage Structs
 */
class EInvoiceCustomerListUpdateResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The DeletedList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEInvoiceCustomerResult
     */
    public $DeletedList;
    /**
     * The InsertedList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEInvoiceCustomerResult
     */
    public $InsertedList;
    /**
     * Constructor method for EInvoiceCustomerListUpdateResult
     * @uses EInvoiceCustomerListUpdateResult::setServiceResult()
     * @uses EInvoiceCustomerListUpdateResult::setErrorCode()
     * @uses EInvoiceCustomerListUpdateResult::setServiceResultDescription()
     * @uses EInvoiceCustomerListUpdateResult::setDeletedList()
     * @uses EInvoiceCustomerListUpdateResult::setInsertedList()
     * @param string $serviceResult
     * @param int $errorCode
     * @param string $serviceResultDescription
     * @param \ArrayType\ArrayOfEInvoiceCustomerResult $deletedList
     * @param \ArrayType\ArrayOfEInvoiceCustomerResult $insertedList
     */
    public function __construct($serviceResult = null, $errorCode = null, $serviceResultDescription = null, \ArrayType\ArrayOfEInvoiceCustomerResult $deletedList = null, \ArrayType\ArrayOfEInvoiceCustomerResult $insertedList = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription)
            ->setDeletedList($deletedList)
            ->setInsertedList($insertedList);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\EInvoiceCustomerListUpdateResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\EInvoiceCustomerListUpdateResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\EInvoiceCustomerListUpdateResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get DeletedList value
     * @return \ArrayType\ArrayOfEInvoiceCustomerResult|null
     */
    public function getDeletedList()
    {
        return $this->DeletedList;
    }
    /**
     * Set DeletedList value
     * @param \ArrayType\ArrayOfEInvoiceCustomerResult $deletedList
     * @return \StructType\EInvoiceCustomerListUpdateResult
     */
    public function setDeletedList(\ArrayType\ArrayOfEInvoiceCustomerResult $deletedList = null)
    {
        $this->DeletedList = $deletedList;
        return $this;
    }
    /**
     * Get InsertedList value
     * @return \ArrayType\ArrayOfEInvoiceCustomerResult|null
     */
    public function getInsertedList()
    {
        return $this->InsertedList;
    }
    /**
     * Set InsertedList value
     * @param \ArrayType\ArrayOfEInvoiceCustomerResult $insertedList
     * @return \StructType\EInvoiceCustomerListUpdateResult
     */
    public function setInsertedList(\ArrayType\ArrayOfEInvoiceCustomerResult $insertedList = null)
    {
        $this->InsertedList = $insertedList;
        return $this;
    }
}
