<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckCustomerTaxIdbyDate StructType
 * @subpackage Structs
 */
class CheckCustomerTaxIdbyDate extends AbstractStructBase
{
    /**
     * The issueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $issueDate;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The TaxIdOrPersonalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxIdOrPersonalId;
    /**
     * Constructor method for CheckCustomerTaxIdbyDate
     * @uses CheckCustomerTaxIdbyDate::setIssueDate()
     * @uses CheckCustomerTaxIdbyDate::setTicket()
     * @uses CheckCustomerTaxIdbyDate::setTaxIdOrPersonalId()
     * @param string $issueDate
     * @param string $ticket
     * @param string $taxIdOrPersonalId
     */
    public function __construct($issueDate = null, $ticket = null, $taxIdOrPersonalId = null)
    {
        $this
            ->setIssueDate($issueDate)
            ->setTicket($ticket)
            ->setTaxIdOrPersonalId($taxIdOrPersonalId);
    }
    /**
     * Get issueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \StructType\CheckCustomerTaxIdbyDate
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CheckCustomerTaxIdbyDate
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get TaxIdOrPersonalId value
     * @return string|null
     */
    public function getTaxIdOrPersonalId()
    {
        return $this->TaxIdOrPersonalId;
    }
    /**
     * Set TaxIdOrPersonalId value
     * @param string $taxIdOrPersonalId
     * @return \StructType\CheckCustomerTaxIdbyDate
     */
    public function setTaxIdOrPersonalId($taxIdOrPersonalId = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdOrPersonalId) && !is_string($taxIdOrPersonalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdOrPersonalId, true), gettype($taxIdOrPersonalId)), __LINE__);
        }
        $this->TaxIdOrPersonalId = $taxIdOrPersonalId;
        return $this;
    }
}
