<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reject ServiceType
 * @subpackage Services
 */
class Reject extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RejectInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RejectInvoice $parameters
     * @return \StructType\RejectInvoiceResponse|bool
     */
    public function RejectInvoice(\StructType\RejectInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RejectInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RejectInvoiceWithNotify
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RejectInvoiceWithNotify $parameters
     * @return \StructType\RejectInvoiceWithNotifyResponse|bool
     */
    public function RejectInvoiceWithNotify(\StructType\RejectInvoiceWithNotify $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RejectInvoiceWithNotify($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RejectInvoiceResponse|\StructType\RejectInvoiceWithNotifyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
