<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceSummary ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceSummary extends AbstractStructArrayBase
{
    /**
     * The InvoiceSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceSummary[]
     */
    public $InvoiceSummary;
    /**
     * Constructor method for ArrayOfInvoiceSummary
     * @uses ArrayOfInvoiceSummary::setInvoiceSummary()
     * @param \StructType\InvoiceSummary[] $invoiceSummary
     */
    public function __construct(array $invoiceSummary = array())
    {
        $this
            ->setInvoiceSummary($invoiceSummary);
    }
    /**
     * Get InvoiceSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceSummary[]|null
     */
    public function getInvoiceSummary()
    {
        return isset($this->InvoiceSummary) ? $this->InvoiceSummary : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceSummaryForArrayConstraintsFromSetInvoiceSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceSummaryInvoiceSummaryItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceSummaryInvoiceSummaryItem instanceof \StructType\InvoiceSummary) {
                $invalidValues[] = is_object($arrayOfInvoiceSummaryInvoiceSummaryItem) ? get_class($arrayOfInvoiceSummaryInvoiceSummaryItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceSummaryInvoiceSummaryItem), var_export($arrayOfInvoiceSummaryInvoiceSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceSummary property can only contain items of type \StructType\InvoiceSummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceSummary[] $invoiceSummary
     * @return \ArrayType\ArrayOfInvoiceSummary
     */
    public function setInvoiceSummary(array $invoiceSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceSummaryArrayErrorMessage = self::validateInvoiceSummaryForArrayConstraintsFromSetInvoiceSummary($invoiceSummary))) {
            throw new \InvalidArgumentException($invoiceSummaryArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceSummary) || (is_array($invoiceSummary) && empty($invoiceSummary))) {
            unset($this->InvoiceSummary);
        } else {
            $this->InvoiceSummary = $invoiceSummary;
        }
        return $this;
    }
    /**
     * Add item to InvoiceSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceSummary $item
     * @return \ArrayType\ArrayOfInvoiceSummary
     */
    public function addToInvoiceSummary(\StructType\InvoiceSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceSummary) {
            throw new \InvalidArgumentException(sprintf('The InvoiceSummary property can only contain items of type \StructType\InvoiceSummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceSummary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceSummary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceSummary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceSummary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceSummary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceSummary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceSummary
     */
    public function getAttributeName()
    {
        return 'InvoiceSummary';
    }
}
