<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GibStatusResult StructType
 * @subpackage Structs
 */
class GibStatusResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The LineResponseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineResponseCode;
    /**
     * The LineResponseDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineResponseDescription;
    /**
     * The Guid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guid;
    /**
     * The GuidType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuidType;
    /**
     * Constructor method for GibStatusResult
     * @uses GibStatusResult::setServiceResult()
     * @uses GibStatusResult::setServiceResultDescription()
     * @uses GibStatusResult::setLineResponseCode()
     * @uses GibStatusResult::setLineResponseDescription()
     * @uses GibStatusResult::setGuid()
     * @uses GibStatusResult::setGuidType()
     * @param string $serviceResult
     * @param string $serviceResultDescription
     * @param string $lineResponseCode
     * @param string $lineResponseDescription
     * @param string $guid
     * @param string $guidType
     */
    public function __construct($serviceResult = null, $serviceResultDescription = null, $lineResponseCode = null, $lineResponseDescription = null, $guid = null, $guidType = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setServiceResultDescription($serviceResultDescription)
            ->setLineResponseCode($lineResponseCode)
            ->setLineResponseDescription($lineResponseDescription)
            ->setGuid($guid)
            ->setGuidType($guidType);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\GibStatusResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\GibStatusResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get LineResponseCode value
     * @return string|null
     */
    public function getLineResponseCode()
    {
        return $this->LineResponseCode;
    }
    /**
     * Set LineResponseCode value
     * @param string $lineResponseCode
     * @return \StructType\GibStatusResult
     */
    public function setLineResponseCode($lineResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($lineResponseCode) && !is_string($lineResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineResponseCode, true), gettype($lineResponseCode)), __LINE__);
        }
        $this->LineResponseCode = $lineResponseCode;
        return $this;
    }
    /**
     * Get LineResponseDescription value
     * @return string|null
     */
    public function getLineResponseDescription()
    {
        return $this->LineResponseDescription;
    }
    /**
     * Set LineResponseDescription value
     * @param string $lineResponseDescription
     * @return \StructType\GibStatusResult
     */
    public function setLineResponseDescription($lineResponseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($lineResponseDescription) && !is_string($lineResponseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineResponseDescription, true), gettype($lineResponseDescription)), __LINE__);
        }
        $this->LineResponseDescription = $lineResponseDescription;
        return $this;
    }
    /**
     * Get Guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->Guid;
    }
    /**
     * Set Guid value
     * @param string $guid
     * @return \StructType\GibStatusResult
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        $this->Guid = $guid;
        return $this;
    }
    /**
     * Get GuidType value
     * @return string|null
     */
    public function getGuidType()
    {
        return $this->GuidType;
    }
    /**
     * Set GuidType value
     * @param string $guidType
     * @return \StructType\GibStatusResult
     */
    public function setGuidType($guidType = null)
    {
        // validation for constraint: string
        if (!is_null($guidType) && !is_string($guidType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidType, true), gettype($guidType)), __LINE__);
        }
        $this->GuidType = $guidType;
        return $this;
    }
}
