<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveReportStateResult StructType
 * @subpackage Structs
 */
class EArchiveReportStateResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ReportStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReportStatusCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The ReportNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportNo;
    /**
     * The ReportStatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportStatusDescription;
    /**
     * Constructor method for EArchiveReportStateResult
     * @uses EArchiveReportStateResult::setServiceResult()
     * @uses EArchiveReportStateResult::setReportStatusCode()
     * @uses EArchiveReportStateResult::setErrorCode()
     * @uses EArchiveReportStateResult::setServiceResultDescription()
     * @uses EArchiveReportStateResult::setReportNo()
     * @uses EArchiveReportStateResult::setReportStatusDescription()
     * @param string $serviceResult
     * @param int $reportStatusCode
     * @param int $errorCode
     * @param string $serviceResultDescription
     * @param string $reportNo
     * @param string $reportStatusDescription
     */
    public function __construct($serviceResult = null, $reportStatusCode = null, $errorCode = null, $serviceResultDescription = null, $reportNo = null, $reportStatusDescription = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setReportStatusCode($reportStatusCode)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription)
            ->setReportNo($reportNo)
            ->setReportStatusDescription($reportStatusDescription);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\EArchiveReportStateResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ReportStatusCode value
     * @return int
     */
    public function getReportStatusCode()
    {
        return $this->ReportStatusCode;
    }
    /**
     * Set ReportStatusCode value
     * @param int $reportStatusCode
     * @return \StructType\EArchiveReportStateResult
     */
    public function setReportStatusCode($reportStatusCode = null)
    {
        // validation for constraint: int
        if (!is_null($reportStatusCode) && !(is_int($reportStatusCode) || ctype_digit($reportStatusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reportStatusCode, true), gettype($reportStatusCode)), __LINE__);
        }
        $this->ReportStatusCode = $reportStatusCode;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\EArchiveReportStateResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\EArchiveReportStateResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get ReportNo value
     * @return string|null
     */
    public function getReportNo()
    {
        return $this->ReportNo;
    }
    /**
     * Set ReportNo value
     * @param string $reportNo
     * @return \StructType\EArchiveReportStateResult
     */
    public function setReportNo($reportNo = null)
    {
        // validation for constraint: string
        if (!is_null($reportNo) && !is_string($reportNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportNo, true), gettype($reportNo)), __LINE__);
        }
        $this->ReportNo = $reportNo;
        return $this;
    }
    /**
     * Get ReportStatusDescription value
     * @return string|null
     */
    public function getReportStatusDescription()
    {
        return $this->ReportStatusDescription;
    }
    /**
     * Set ReportStatusDescription value
     * @param string $reportStatusDescription
     * @return \StructType\EArchiveReportStateResult
     */
    public function setReportStatusDescription($reportStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($reportStatusDescription) && !is_string($reportStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportStatusDescription, true), gettype($reportStatusDescription)), __LINE__);
        }
        $this->ReportStatusDescription = $reportStatusDescription;
        return $this;
    }
}
