<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveInvoiceStateResult StructType
 * @subpackage Structs
 */
class EArchiveInvoiceStateResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The InvoiceStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceStatusCode;
    /**
     * The HasCancelInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasCancelInvoice;
    /**
     * The CancelStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CancelStatusCode;
    /**
     * The CancelDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CancelDate;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The InvoiceStatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceStatusDescription;
    /**
     * The CancelStatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CancelStatusDescription;
    /**
     * Constructor method for EArchiveInvoiceStateResult
     * @uses EArchiveInvoiceStateResult::setServiceResult()
     * @uses EArchiveInvoiceStateResult::setInvoiceStatusCode()
     * @uses EArchiveInvoiceStateResult::setHasCancelInvoice()
     * @uses EArchiveInvoiceStateResult::setCancelStatusCode()
     * @uses EArchiveInvoiceStateResult::setCancelDate()
     * @uses EArchiveInvoiceStateResult::setErrorCode()
     * @uses EArchiveInvoiceStateResult::setServiceResultDescription()
     * @uses EArchiveInvoiceStateResult::setUUID()
     * @uses EArchiveInvoiceStateResult::setInvoiceId()
     * @uses EArchiveInvoiceStateResult::setInvoiceStatusDescription()
     * @uses EArchiveInvoiceStateResult::setCancelStatusDescription()
     * @param string $serviceResult
     * @param int $invoiceStatusCode
     * @param bool $hasCancelInvoice
     * @param int $cancelStatusCode
     * @param string $cancelDate
     * @param int $errorCode
     * @param string $serviceResultDescription
     * @param string $uUID
     * @param string $invoiceId
     * @param string $invoiceStatusDescription
     * @param string $cancelStatusDescription
     */
    public function __construct($serviceResult = null, $invoiceStatusCode = null, $hasCancelInvoice = null, $cancelStatusCode = null, $cancelDate = null, $errorCode = null, $serviceResultDescription = null, $uUID = null, $invoiceId = null, $invoiceStatusDescription = null, $cancelStatusDescription = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setInvoiceStatusCode($invoiceStatusCode)
            ->setHasCancelInvoice($hasCancelInvoice)
            ->setCancelStatusCode($cancelStatusCode)
            ->setCancelDate($cancelDate)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription)
            ->setUUID($uUID)
            ->setInvoiceId($invoiceId)
            ->setInvoiceStatusDescription($invoiceStatusDescription)
            ->setCancelStatusDescription($cancelStatusDescription);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get InvoiceStatusCode value
     * @return int
     */
    public function getInvoiceStatusCode()
    {
        return $this->InvoiceStatusCode;
    }
    /**
     * Set InvoiceStatusCode value
     * @param int $invoiceStatusCode
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setInvoiceStatusCode($invoiceStatusCode = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceStatusCode) && !(is_int($invoiceStatusCode) || ctype_digit($invoiceStatusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceStatusCode, true), gettype($invoiceStatusCode)), __LINE__);
        }
        $this->InvoiceStatusCode = $invoiceStatusCode;
        return $this;
    }
    /**
     * Get HasCancelInvoice value
     * @return bool
     */
    public function getHasCancelInvoice()
    {
        return $this->HasCancelInvoice;
    }
    /**
     * Set HasCancelInvoice value
     * @param bool $hasCancelInvoice
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setHasCancelInvoice($hasCancelInvoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasCancelInvoice) && !is_bool($hasCancelInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasCancelInvoice, true), gettype($hasCancelInvoice)), __LINE__);
        }
        $this->HasCancelInvoice = $hasCancelInvoice;
        return $this;
    }
    /**
     * Get CancelStatusCode value
     * @return int
     */
    public function getCancelStatusCode()
    {
        return $this->CancelStatusCode;
    }
    /**
     * Set CancelStatusCode value
     * @param int $cancelStatusCode
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setCancelStatusCode($cancelStatusCode = null)
    {
        // validation for constraint: int
        if (!is_null($cancelStatusCode) && !(is_int($cancelStatusCode) || ctype_digit($cancelStatusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cancelStatusCode, true), gettype($cancelStatusCode)), __LINE__);
        }
        $this->CancelStatusCode = $cancelStatusCode;
        return $this;
    }
    /**
     * Get CancelDate value
     * @return string
     */
    public function getCancelDate()
    {
        return $this->CancelDate;
    }
    /**
     * Set CancelDate value
     * @param string $cancelDate
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setCancelDate($cancelDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelDate) && !is_string($cancelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelDate, true), gettype($cancelDate)), __LINE__);
        }
        $this->CancelDate = $cancelDate;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get InvoiceStatusDescription value
     * @return string|null
     */
    public function getInvoiceStatusDescription()
    {
        return $this->InvoiceStatusDescription;
    }
    /**
     * Set InvoiceStatusDescription value
     * @param string $invoiceStatusDescription
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setInvoiceStatusDescription($invoiceStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceStatusDescription) && !is_string($invoiceStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceStatusDescription, true), gettype($invoiceStatusDescription)), __LINE__);
        }
        $this->InvoiceStatusDescription = $invoiceStatusDescription;
        return $this;
    }
    /**
     * Get CancelStatusDescription value
     * @return string|null
     */
    public function getCancelStatusDescription()
    {
        return $this->CancelStatusDescription;
    }
    /**
     * Set CancelStatusDescription value
     * @param string $cancelStatusDescription
     * @return \StructType\EArchiveInvoiceStateResult
     */
    public function setCancelStatusDescription($cancelStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cancelStatusDescription) && !is_string($cancelStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelStatusDescription, true), gettype($cancelStatusDescription)), __LINE__);
        }
        $this->CancelStatusDescription = $cancelStatusDescription;
        return $this;
    }
}
