<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Accept ServiceType
 * @subpackage Services
 */
class Accept extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AcceptInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AcceptInvoice $parameters
     * @return \StructType\AcceptInvoiceResponse|bool
     */
    public function AcceptInvoice(\StructType\AcceptInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AcceptInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AcceptInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
