<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceOption extends AbstractStructArrayBase
{
    /**
     * The InvoiceOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceOption[]
     */
    public $InvoiceOption;
    /**
     * Constructor method for ArrayOfInvoiceOption
     * @uses ArrayOfInvoiceOption::setInvoiceOption()
     * @param \StructType\InvoiceOption[] $invoiceOption
     */
    public function __construct(array $invoiceOption = array())
    {
        $this
            ->setInvoiceOption($invoiceOption);
    }
    /**
     * Get InvoiceOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceOption[]|null
     */
    public function getInvoiceOption()
    {
        return isset($this->InvoiceOption) ? $this->InvoiceOption : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceOptionForArrayConstraintsFromSetInvoiceOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceOptionInvoiceOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceOptionInvoiceOptionItem instanceof \StructType\InvoiceOption) {
                $invalidValues[] = is_object($arrayOfInvoiceOptionInvoiceOptionItem) ? get_class($arrayOfInvoiceOptionInvoiceOptionItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceOptionInvoiceOptionItem), var_export($arrayOfInvoiceOptionInvoiceOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceOption property can only contain items of type \StructType\InvoiceOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceOption[] $invoiceOption
     * @return \ArrayType\ArrayOfInvoiceOption
     */
    public function setInvoiceOption(array $invoiceOption = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceOptionArrayErrorMessage = self::validateInvoiceOptionForArrayConstraintsFromSetInvoiceOption($invoiceOption))) {
            throw new \InvalidArgumentException($invoiceOptionArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceOption) || (is_array($invoiceOption) && empty($invoiceOption))) {
            unset($this->InvoiceOption);
        } else {
            $this->InvoiceOption = $invoiceOption;
        }
        return $this;
    }
    /**
     * Add item to InvoiceOption value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceOption $item
     * @return \ArrayType\ArrayOfInvoiceOption
     */
    public function addToInvoiceOption(\StructType\InvoiceOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceOption) {
            throw new \InvalidArgumentException(sprintf('The InvoiceOption property can only contain items of type \StructType\InvoiceOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceOption
     */
    public function getAttributeName()
    {
        return 'InvoiceOption';
    }
}
