<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutsiderMailMessage StructType
 * @subpackage Structs
 */
class OutsiderMailMessage extends AbstractStructBase
{
    /**
     * The From
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From;
    /**
     * The MailCC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $MailCC;
    /**
     * The MailTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailTo;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Body;
    /**
     * The eledgerParent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $eledgerParent;
    /**
     * The mailDayDirectory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailDayDirectory;
    /**
     * The LogFileAttachs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOutSiderMailMessageAttach
     */
    public $LogFileAttachs;
    /**
     * Constructor method for OutsiderMailMessage
     * @uses OutsiderMailMessage::setFrom()
     * @uses OutsiderMailMessage::setMailCC()
     * @uses OutsiderMailMessage::setMailTo()
     * @uses OutsiderMailMessage::setSubject()
     * @uses OutsiderMailMessage::setBody()
     * @uses OutsiderMailMessage::setEledgerParent()
     * @uses OutsiderMailMessage::setMailDayDirectory()
     * @uses OutsiderMailMessage::setLogFileAttachs()
     * @param string $from
     * @param \ArrayType\ArrayOfString $mailCC
     * @param string $mailTo
     * @param string $subject
     * @param string $body
     * @param string $eledgerParent
     * @param string $mailDayDirectory
     * @param \ArrayType\ArrayOfOutSiderMailMessageAttach $logFileAttachs
     */
    public function __construct($from = null, \ArrayType\ArrayOfString $mailCC = null, $mailTo = null, $subject = null, $body = null, $eledgerParent = null, $mailDayDirectory = null, \ArrayType\ArrayOfOutSiderMailMessageAttach $logFileAttachs = null)
    {
        $this
            ->setFrom($from)
            ->setMailCC($mailCC)
            ->setMailTo($mailTo)
            ->setSubject($subject)
            ->setBody($body)
            ->setEledgerParent($eledgerParent)
            ->setMailDayDirectory($mailDayDirectory)
            ->setLogFileAttachs($logFileAttachs);
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\OutsiderMailMessage
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get MailCC value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getMailCC()
    {
        return $this->MailCC;
    }
    /**
     * Set MailCC value
     * @param \ArrayType\ArrayOfString $mailCC
     * @return \StructType\OutsiderMailMessage
     */
    public function setMailCC(\ArrayType\ArrayOfString $mailCC = null)
    {
        $this->MailCC = $mailCC;
        return $this;
    }
    /**
     * Get MailTo value
     * @return string|null
     */
    public function getMailTo()
    {
        return $this->MailTo;
    }
    /**
     * Set MailTo value
     * @param string $mailTo
     * @return \StructType\OutsiderMailMessage
     */
    public function setMailTo($mailTo = null)
    {
        // validation for constraint: string
        if (!is_null($mailTo) && !is_string($mailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailTo, true), gettype($mailTo)), __LINE__);
        }
        $this->MailTo = $mailTo;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\OutsiderMailMessage
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Body value
     * @return string|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param string $body
     * @return \StructType\OutsiderMailMessage
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($body, true), gettype($body)), __LINE__);
        }
        $this->Body = $body;
        return $this;
    }
    /**
     * Get eledgerParent value
     * @return string|null
     */
    public function getEledgerParent()
    {
        return $this->eledgerParent;
    }
    /**
     * Set eledgerParent value
     * @param string $eledgerParent
     * @return \StructType\OutsiderMailMessage
     */
    public function setEledgerParent($eledgerParent = null)
    {
        // validation for constraint: string
        if (!is_null($eledgerParent) && !is_string($eledgerParent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eledgerParent, true), gettype($eledgerParent)), __LINE__);
        }
        $this->eledgerParent = $eledgerParent;
        return $this;
    }
    /**
     * Get mailDayDirectory value
     * @return string|null
     */
    public function getMailDayDirectory()
    {
        return $this->mailDayDirectory;
    }
    /**
     * Set mailDayDirectory value
     * @param string $mailDayDirectory
     * @return \StructType\OutsiderMailMessage
     */
    public function setMailDayDirectory($mailDayDirectory = null)
    {
        // validation for constraint: string
        if (!is_null($mailDayDirectory) && !is_string($mailDayDirectory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailDayDirectory, true), gettype($mailDayDirectory)), __LINE__);
        }
        $this->mailDayDirectory = $mailDayDirectory;
        return $this;
    }
    /**
     * Get LogFileAttachs value
     * @return \ArrayType\ArrayOfOutSiderMailMessageAttach|null
     */
    public function getLogFileAttachs()
    {
        return $this->LogFileAttachs;
    }
    /**
     * Set LogFileAttachs value
     * @param \ArrayType\ArrayOfOutSiderMailMessageAttach $logFileAttachs
     * @return \StructType\OutsiderMailMessage
     */
    public function setLogFileAttachs(\ArrayType\ArrayOfOutSiderMailMessageAttach $logFileAttachs = null)
    {
        $this->LogFileAttachs = $logFileAttachs;
        return $this;
    }
}
